/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.proxy;

import java.io.File;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import whatap.agent.Logger;
import whatap.agent.conf.ConfSysMon;
import whatap.agent.proxy.IOshi;
import whatap.agent.proxy.LoaderManager;
import whatap.lang.pack.TagCountPack;
import whatap.oshi.Cpu;
import whatap.util.FileUtil;
import whatap.util.JarUtil;
import whatap.util.StopWatch;
import whatap.util.SystemUtil;

public class OshiFactory {
    private static final String OSHI = "whatap.xtra.oshi.OshiMain";
    public static final IOshi dummy = new IOshi(){

        public int pid() {
            return 0;
        }

        public Cpu getCpu() {
            return new Cpu();
        }

        public float mem() {
            return 0.0f;
        }

        public float swap() {
            return 0.0f;
        }

        public float disk(String dir) {
            return 0.0f;
        }

        public float procCpu(int pid) {
            return 0.0f;
        }

        public TagCountPack network() {
            return null;
        }

        public long procMemRss(int pid) {
            return 0L;
        }

        public void loadPlugin() {
        }
    };

    public static IOshi create() {
        if (!ConfSysMon.oshi_enabled) {
            return dummy;
        }
        try {
            OshiFactory.deployLib1("lib5");
            ClassLoader loader = LoaderManager.getOshiLoader("lib5");
            if (loader == null) {
                return dummy;
            }
            Class<?> c = Class.forName(OSHI, true, loader);
            return (IOshi)c.newInstance();
        }
        catch (Throwable e) {
            e.printStackTrace();
            Logger.println("OSHI", 10, "fail to create", e);
            return dummy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deployLib1(String libname) {
        StopWatch sw = new StopWatch();
        String thisJarPath = JarUtil.getThisJarName(OshiFactory.class);
        String location = new File(thisJarPath).getParent();
        File base = new File(location, libname);
        if (base.exists()) {
            Logger.println("OSHI", "[" + libname + "] is already installed");
            return;
        }
        if (!SystemUtil.IS_JAVA_1_5) {
            try {
                base.setWritable(true);
                base.setExecutable(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        base.mkdirs();
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(thisJarPath);
            Enumeration<JarEntry> en = jarFile.entries();
            while (en.hasMoreElements()) {
                JarEntry ent = en.nextElement();
                if (!ent.getName().startsWith(libname) || ent.isDirectory()) continue;
                String justFileName = ent.getName().substring(ent.getName().lastIndexOf("/") + 1);
                InputStream input = null;
                try {
                    input = jarFile.getInputStream(ent);
                    byte[] b = FileUtil.readAll(input);
                    FileUtil.save(new File(base, justFileName), b);
                }
                finally {
                    FileUtil.close(input);
                }
            }
            FileUtil.save(new File(base, libname + ".done"), new byte[0]);
        }
        catch (Exception e) {
            try {
                Logger.println("A143", 10, (Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtil.close(jarFile);
                throw throwable;
            }
            FileUtil.close(jarFile);
        }
        FileUtil.close(jarFile);
        Logger.println("A144", 10, "[" + libname + "] is just installed " + sw.getTime() + " ms");
    }
}

