/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.plugin;

import whatap.agent.data.DataTextAgent;
import whatap.agent.trace.TraceContext;
import whatap.lang.step.MessageStep;
import whatap.lang.value.DecimalValue;
import whatap.lang.value.TextValue;
import whatap.lang.value.Value;
import whatap.util.HashUtil;
import whatap.util.IPUtil;
import whatap.util.SysJMX;

public class WrContext {
    private TraceContext ctx;

    public WrContext(TraceContext ctx) {
        this.ctx = ctx;
    }

    public String service() {
        if (this.ctx == null) {
            return null;
        }
        return this.ctx.service_name;
    }

    public void service(String name) {
        if (name == null) {
            return;
        }
        this.ctx.service_hash = HashUtil.hash(name);
        this.ctx.service_name = name;
    }

    public int serviceHash() {
        if (this.ctx == null) {
            return 0;
        }
        return this.ctx.service_hash;
    }

    public void remoteIp(String ip) {
        if (this.ctx == null) {
            return;
        }
        this.ctx.remoteIp = IPUtil.toInt(ip);
    }

    public String remoteIp() {
        if (this.ctx == null) {
            return null;
        }
        return IPUtil.toString(this.ctx.remoteIp);
    }

    public boolean isError() {
        if (this.ctx == null) {
            return false;
        }
        return this.ctx.error != null;
    }

    public void login(String id) {
        if (this.ctx == null) {
            return;
        }
        this.ctx.login = id;
    }

    public String login() {
        if (this.ctx == null) {
            return null;
        }
        return this.ctx.login;
    }

    public String httpURL() {
        if (this.ctx == null) {
            return null;
        }
        return this.ctx.http_url.toString();
    }

    public String httpMethod() {
        if (this.ctx == null) {
            return null;
        }
        return this.ctx.http_method;
    }

    public String httpQuery() {
        if (this.ctx == null) {
            return null;
        }
        return this.ctx.http_query;
    }

    public String httpContentType() {
        if (this.ctx == null) {
            return null;
        }
        return this.ctx.http_content_type;
    }

    public String userAgent() {
        if (this.ctx == null) {
            return null;
        }
        return this.ctx.userAgentString;
    }

    public int status() {
        if (this.ctx == null) {
            return 0;
        }
        return this.ctx.status;
    }

    public TraceContext inner() {
        return this.ctx;
    }

    public boolean ok() {
        return this.ctx != null;
    }

    public void profile(String desc) {
        this.profile("custom", desc);
    }

    public void profile(String name, String msg) {
        MessageStep p = new MessageStep();
        p.start_time = this.ctx.getElapsedTime();
        p.hash = HashUtil.hash(name);
        DataTextAgent.MESSAGE.add(p.hash, name);
        p.desc = msg;
        this.ctx.profile.add(p);
    }

    public void profile(String name, String msg, int elapsed) {
        MessageStep p = new MessageStep();
        p.start_time = this.ctx.getElapsedTime();
        p.hash = HashUtil.hash(name);
        DataTextAgent.MESSAGE.add(p.hash, name);
        p.desc = msg;
        p.time = elapsed;
        this.ctx.profile.add(p);
    }

    public void profile(String name, String msg, int elapsed, int value) {
        MessageStep p = new MessageStep();
        p.start_time = this.ctx.getElapsedTime();
        p.hash = HashUtil.hash(name);
        DataTextAgent.MESSAGE.add(p.hash, name);
        p.desc = msg;
        p.time = elapsed;
        p.value = value;
        this.ctx.profile.add(p);
    }

    public void profx(String name) {
        if (this.ctx == null) {
            return;
        }
        int cpu = (int)(SysJMX.getCurrentThreadCPU() - this.ctx.start_cpu);
        long mem = (int)(SysJMX.getCurrentThreadAllocBytes() - this.ctx.start_malloc);
        MessageStep p = new MessageStep();
        p.start_time = this.ctx.getElapsedTime();
        p.hash = HashUtil.hash(name);
        p.desc = "cpu: " + cpu + " mem: " + mem;
        DataTextAgent.MESSAGE.add(p.hash, name);
        this.ctx.profile.add(p);
    }

    public void setAttribute(String key, String value) {
        if (this.ctx == null) {
            return;
        }
        this.ctx.setExtraField(key, new TextValue(value));
    }

    public String getAttribute(String key) {
        if (this.ctx == null || this.ctx.fields == null) {
            return null;
        }
        return this.ctx.fields.getText(key);
    }

    public void ignore() {
        if (this.ctx != null) {
            this.ctx.isStaticContents = true;
        }
    }

    public boolean isIgnored() {
        if (this.ctx != null) {
            return this.ctx.isStaticContents;
        }
        return true;
    }

    public void clearException() {
        if (this.ctx != null) {
            this.ctx.exception = null;
        }
    }

    public boolean isException(String word) {
        if (this.ctx != null && this.ctx.exception != null) {
            if (word == null || word.length() == 0) {
                return true;
            }
            return this.ctx.exception.getClass().getName().indexOf(word) >= 0;
        }
        return false;
    }

    public long mtid() {
        if (this.ctx != null) {
            return this.ctx.mtid;
        }
        return 0L;
    }

    public boolean hasContentType() {
        return this.ctx != null && this.ctx.http_content_type != null;
    }

    public boolean isMultipartContent() {
        return this.ctx.http_content_type.indexOf("multipart") >= 0;
    }

    public boolean isFormEncoded() {
        return "application/x-www-form-urlencoded".equals(this.ctx.http_content_type);
    }

    public void setExtraField(String key, String value) {
        if (this.ctx != null) {
            this.ctx.setExtraField(key, new TextValue(value));
        }
    }

    public void setExtraField(String key, long value) {
        if (this.ctx != null) {
            this.ctx.setExtraField(key, new DecimalValue(value));
        }
    }

    public String getExtraField(String key) {
        Value v;
        if (this.ctx != null && (v = this.ctx.getExtraField(key)) != null) {
            return v.toString();
        }
        return null;
    }
}

