/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.plugin;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import whatap.agent.Logger;
import whatap.agent.plugin.Wrapper;
import whatap.agent.trace.HookArgs;
import whatap.agent.util.AsyncRunner;
import whatap.org.json.JSONObject;
import whatap.util.AnsiPrint;
import whatap.util.CastUtil;
import whatap.util.ClassUtil;
import whatap.util.HashUtil;
import whatap.util.RunExec;
import whatap.util.StringUtil;

public class AbstractPlugin {
    public final String id;
    public long lastModified;
    public long interval;

    public AbstractPlugin(String id) {
        this.id = id;
    }

    public void log(Object c) {
        Logger.info(this.id, c == null ? "null" : c.toString());
    }

    public void println(Object c) {
        System.out.println(c);
    }

    public Object field(Object o, String field) {
        if (o == null) {
            return null;
        }
        try {
            Field f = o.getClass().getField(field);
            f.setAccessible(true);
            return f.get(o);
        }
        catch (Throwable e) {
            Logger.println(this.id, 10, this.getClass().getName() + " " + e);
            return null;
        }
    }

    public Object method(Object o, String method) {
        if (o == null) {
            return null;
        }
        try {
            Method m = o.getClass().getMethod(method, Wrapper.arg_c);
            m.setAccessible(true);
            return m.invoke(o, Wrapper.arg_o);
        }
        catch (Throwable e) {
            Logger.println(this.id, 10, this.getClass().getName() + " " + e);
            return null;
        }
    }

    public Object method(Object o, String method, String param) {
        if (o == null) {
            return null;
        }
        try {
            Method m = o.getClass().getMethod(method, Wrapper.arg_c_s);
            return m.invoke(o, param);
        }
        catch (Throwable e) {
            Logger.println(this.id, 10, this.getClass().getName() + " " + e);
            return null;
        }
    }

    public String toString(Object o) {
        return o == null ? null : o.toString();
    }

    public String toString(Object o, String def) {
        return o == null ? def : o.toString();
    }

    public int syshash(Object o) {
        if (o == null) {
            return 0;
        }
        return System.identityHashCode(o);
    }

    public int syshash(HookArgs hook, int x) {
        if (x >= hook.args.length) {
            return 0;
        }
        return this.syshash(hook.args[x]);
    }

    public int syshash(HookArgs hook) {
        if (hook == null || hook.this1 == null) {
            return 0;
        }
        return this.syshash(hook.this1);
    }

    public int cint(Object o) {
        return CastUtil.cint(o);
    }

    public float cfloat(Object o) {
        return CastUtil.cfloat(o);
    }

    public String cString(Object o) {
        return CastUtil.cString(o);
    }

    public long clong(Object o) {
        return CastUtil.clong(o);
    }

    public double cdouble(Object o) {
        return CastUtil.cdouble(o);
    }

    public void $interval(long interval) {
        this.interval = interval;
    }

    public String desc(Object o) {
        if (o == null) {
            return "null";
        }
        return ClassUtil.getClassDescription(o.getClass(), true);
    }

    public static String toJson(Object o1) {
        if (o1 == null) {
            return "{}";
        }
        Class<?> c1 = o1.getClass();
        JSONObject j = new JSONObject();
        Field[] f = c1.getFields();
        for (int i = 0; i < f.length; ++i) {
            try {
                f[i].setAccessible(true);
                Object o = f[i].get(o1);
                j.put(f[i].getName(), o);
                continue;
            }
            catch (Exception e) {
                j.put("_error_", e);
            }
        }
        return j.toString();
    }

    public long hash64(String id) {
        return HashUtil.hash64(id);
    }

    public int hash(String id) {
        if (id == null) {
            return 0;
        }
        return HashUtil.hash(id.getBytes());
    }

    public void shell(final String cmd, final String env) {
        AsyncRunner.getInstance().add(new Runnable(){

            public void run() {
                RunExec run = new RunExec(cmd);
                if (env != null) {
                    run.setEnv(StringUtil.tokenizer(env, ","));
                }
                run.exec();
            }
        });
    }

    public String red(String s) {
        return AnsiPrint.red(s);
    }

    public String green(String s) {
        return AnsiPrint.green(s);
    }

    public String yellow(String s) {
        return AnsiPrint.yellow(s);
    }
}

