/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.open;

import java.util.Properties;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.SecurityMaster;
import whatap.agent.data.DataPackSender;
import whatap.agent.open.OpenInfo;
import whatap.lang.WsKey;
import whatap.lang.pack.AgentPropertyPack;
import whatap.util.AnsiPrint;
import whatap.util.DateUtil;

public class OpenMxAgentProperty {
    static long sent_count = 0L;
    static long last_send = 0L;

    static void send() {
        String service;
        Configure conf = Configure.getInstance();
        if (!conf.agent_property_enabled) {
            return;
        }
        long now = DateUtil.nanoToMillis();
        if (sent_count < 2L ? now - last_send < 5000L : now - last_send < 300000L) {
            return;
        }
        last_send = now;
        if (!OpenInfo.isInitialized()) {
            return;
        }
        SecurityMaster secu = SecurityMaster.getInstance();
        if (secu.WSID == 0) {
            return;
        }
        AgentPropertyPack pack = new AgentPropertyPack();
        Properties prop = conf.property;
        for (String key : prop.stringPropertyNames()) {
            if (!key.startsWith(OpenInfo.PROPERTY_KEY_PREFIX)) continue;
            String value = prop.getProperty(key);
            String key2 = key.substring(OpenInfo.PROPERTY_KEY_PREFIX.length());
            pack.put(key2, value);
        }
        pack.put("oname", secu.ONAME);
        pack.put("anchor_id", secu.OID + "@" + new WsKey(secu.WSID, secu.PRODUCT, secu.SYS_ID));
        pack.put("anchor_product", String.valueOf(secu.PRODUCT));
        pack.put("anchor_sysid", String.valueOf(secu.SYS_ID));
        pack.put("anchor_oid", String.valueOf(secu.OID));
        pack.put("anchor_oname", String.valueOf(secu.ONAME));
        pack.put("runtype", "openmx");
        pack.put("runlevel", "5");
        if (pack.get("service") == null && (service = prop.getProperty("property@service")) != null) {
            pack.put("service", service);
        }
        pack.pcode = OpenInfo.getPcode();
        pack.oid = OpenInfo.getOid();
        ++sent_count;
        DataPackSender.sendToRouter(pack);
        Logger.println("OpenMxAgentProperty service=" + AnsiPrint.yellow(pack.get("service")) + " anchor_id=" + AnsiPrint.yellow(pack.get("anchor_id")));
    }
}

