/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.task.res.util;

import java.net.URL;
import java.util.Iterator;
import whatap.agent.Logger;
import whatap.agent.conf.ConfSysMon;
import whatap.agent.util.HttpClientUtil;
import whatap.org.json.JSONObject;
import whatap.util.StringUtil;
import whatap.util.ThreadUtil;

public class AwsEcsClientThread
extends Thread {
    private static AwsEcsClientThread instance = null;
    String meta_uri;
    static final int CHECK_MAX = 3;
    public float millicore;
    long last_milli_check;
    int check;
    public float cpu;
    public float cpu_sys;
    public float cpu_user;
    public float mem_pct;

    public static final synchronized AwsEcsClientThread getInstance() {
        if (instance == null) {
            instance = new AwsEcsClientThread();
            instance.setDaemon(true);
            instance.setName("AwsEcsClient");
            instance.start();
        }
        return instance;
    }

    private AwsEcsClientThread() {
        block5: {
            this.meta_uri = "";
            this.millicore = 0.0f;
            this.last_milli_check = 0L;
            this.check = 3;
            try {
                Iterator<String> en = System.getenv().keySet().iterator();
                if (en == null) break block5;
                while (en.hasNext()) {
                    String tempUri;
                    String envKey = en.next();
                    if (ConfSysMon.aws_ecs_metadata_uri_recent_enabled) {
                        if (!envKey.startsWith("ECS_CONTAINER_METADATA_URI") || (tempUri = System.getenv(envKey)) == null || this.meta_uri.compareTo(tempUri) >= 0) continue;
                        this.meta_uri = tempUri;
                        continue;
                    }
                    if (!envKey.equals("ECS_CONTAINER_METADATA_URI")) continue;
                    tempUri = System.getenv(envKey);
                    if (tempUri != null) {
                        this.meta_uri = tempUri;
                    }
                    break;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void run() {
        while (true) {
            ThreadUtil.sleep(ConfSysMon.aws_ecs_stat_interval);
            try {
                if (ConfSysMon.aws_ecs_enabled) {
                    if (this.meta_uri == null || this.meta_uri.length() <= 0) continue;
                    this.getCpuLimit(this.meta_uri);
                    this.process(this.meta_uri);
                    continue;
                }
                ThreadUtil.sleep(11000L);
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
                continue;
            }
            break;
        }
    }

    void getCpuLimit(String meta_uri) throws Exception {
        block8: {
            if (this.check < 0) {
                return;
            }
            long now = System.currentTimeMillis();
            if (now - 28800000L < this.last_milli_check) {
                return;
            }
            String meta_uri_chk = meta_uri;
            if (ConfSysMon.aws_ecs_limits_uri_postfix_enabled && ConfSysMon.aws_ecs_limits_uri_postfix != null && ConfSysMon.aws_ecs_limits_uri_postfix.length() > 0) {
                meta_uri_chk = meta_uri_chk + ConfSysMon.aws_ecs_limits_uri_postfix;
            }
            String o = HttpClientUtil.read(new URL(meta_uri_chk), 3000);
            try {
                JSONObject json = new JSONObject(o);
                if (json.has("Limits")) {
                    JSONObject Limits = json.getJSONObject("Limits");
                    this.millicore = (float)Limits.optDouble("CPU");
                    if (this.millicore < 128.0f) {
                        this.millicore *= 1024.0f;
                    }
                    Logger.println("SysCpu", 60, "ECS CPU Limits : " + this.millicore / 1024.0f + " core");
                }
            }
            catch (Throwable t) {
                this.millicore = 0.0f;
                if (--this.check < 0) break block8;
                Logger.green("ECS-ERR " + t.getMessage());
            }
        }
        if (this.millicore > 0.0f) {
            this.last_milli_check = System.currentTimeMillis();
        }
    }

    public void process(String meta_uri) throws Exception {
        String stats = HttpClientUtil.read(new URL(meta_uri + "/stats"), 3000);
        if (StringUtil.isEmpty(stats)) {
            this.reset();
            return;
        }
        JSONObject o = new JSONObject(stats);
        if (ConfSysMon.debug_aws_ecs_enabled) {
            Logger.println("AwsEcsClient", 30, "meta_uri=" + meta_uri + " stats\n" + o.toString(4));
        }
        JSONObject precpu_stats = o.optJSONObject("precpu_stats");
        JSONObject cpu_stats = o.optJSONObject("cpu_stats");
        JSONObject memory_stats = o.optJSONObject("memory_stats");
        long system_cpu_usage = this.delta(precpu_stats, cpu_stats, "system_cpu_usage");
        if (system_cpu_usage > 0L) {
            JSONObject precpu_usage = precpu_stats.optJSONObject("cpu_usage");
            JSONObject cpu_usage = cpu_stats.optJSONObject("cpu_usage");
            long usage_tot = this.delta(precpu_usage, cpu_usage, "total_usage");
            long usage_sys = this.delta(precpu_usage, cpu_usage, "usage_in_kernelmode");
            long usage_usr = this.delta(precpu_usage, cpu_usage, "usage_in_usermode");
            this.cpu = (float)usage_tot * 100.0f / (float)system_cpu_usage;
            this.cpu_sys = (float)usage_sys * 100.0f / (float)system_cpu_usage;
            this.cpu_user = (float)usage_usr * 100.0f / (float)system_cpu_usage;
        } else {
            this.reset();
        }
        if (memory_stats != null) {
            long mem_usage = memory_stats.optLong("usage");
            JSONObject memory_stats_stats = memory_stats.optJSONObject("stats");
            if (memory_stats_stats != null) {
                long mem_limit = memory_stats_stats.optLong("hierarchical_memory_limit");
                this.mem_pct = (float)mem_usage * 100.0f / (float)mem_limit;
            } else {
                this.mem_pct = 0.0f;
            }
        } else {
            this.mem_pct = 0.0f;
        }
    }

    private void reset() {
        this.cpu = 0.0f;
        this.cpu_sys = 0.0f;
        this.cpu_user = 0.0f;
    }

    private long delta(JSONObject j1, JSONObject j2, String key) {
        if (j1 == null || j2 == null) {
            return 0L;
        }
        long v1 = j1.optLong(key);
        long v2 = j2.optLong(key);
        return v2 - v1;
    }

    public static void main(String[] args) {
        String stats = "{\n    \"blkio_stats\": {\n        \"io_merged_recursive\": [],\n        \"io_queue_recursive\": [],\n        \"io_service_bytes_recursive\": [\n            {\n                \"major\": 259,\n                \"minor\": 3,\n                \"op\": \"Read\",\n                \"value\": 0\n            },\n            {\n                \"major\": 259,\n                \"minor\": 3,\n                \"op\": \"Write\",\n                \"value\": 45514752\n            },\n            {\n                \"major\": 259,\n                \"minor\": 3,\n                \"op\": \"Sync\",\n                \"value\": 4268032\n            },\n            {\n                \"major\": 259,\n                \"minor\": 3,\n                \"op\": \"Async\",\n                \"value\": 41246720\n            },\n            {\n                \"major\": 259,\n                \"minor\": 3,\n                \"op\": \"Discard\",\n                \"value\": 0\n            },\n            {\n                \"major\": 259,\n                \"minor\": 3,\n                \"op\": \"Total\",\n                \"value\": 45514752\n            }\n        ],\n        \"io_service_time_recursive\": [],\n        \"io_serviced_recursive\": [\n            {\n                \"major\": 259,\n                \"minor\": 3,\n                \"op\": \"Read\",\n                \"value\": 0\n            },\n            {\n                \"major\": 259,\n                \"minor\": 3,\n                \"op\": \"Write\",\n                \"value\": 342\n            },\n            {\n                \"major\": 259,\n                \"minor\": 3,\n                \"op\": \"Sync\",\n                \"value\": 272\n            },\n            {\n                \"major\": 259,\n                \"minor\": 3,\n                \"op\": \"Async\",\n                \"value\": 70\n            },\n            {\n                \"major\": 259,\n                \"minor\": 3,\n                \"op\": \"Discard\",\n                \"value\": 0\n            },\n            {\n                \"major\": 259,\n                \"minor\": 3,\n                \"op\": \"Total\",\n                \"value\": 342\n            }\n        ],\n        \"io_time_recursive\": [],\n        \"io_wait_time_recursive\": [],\n        \"sectors_recursive\": []\n    },\n    \"cpu_stats\": {\n        \"cpu_usage\": {\n            \"percpu_usage\": [\n                5585610339,\n                5944268076\n            ],\n            \"total_usage\": 15373171220,\n            \"usage_in_kernelmode\": 2150000000,\n            \"usage_in_usermode\": 7990000000\n        },\n        \"online_cpus\": 2,\n        \"throttling_data\": {\n            \"periods\": 0,\n            \"throttled_periods\": 0,\n            \"throttled_time\": 0\n        }\n    },\n    \"id\": \"10b741d47dc649d5b321f83c7c14c950-441560335\",\n    \"memory_stats\": {\n        \"limit\": 9223372036854771712,\n        \"max_usage\": 246165504,\n        \"stats\": {\n            \"active_anon\": 0,\n            \"active_file\": 27439104,\n            \"cache\": 56365056,\n            \"dirty\": 0,\n            \"hierarchical_memory_limit\": 2147483648,\n            \"hierarchical_memsw_limit\": 9223372036854771712,\n            \"inactive_anon\": 98267136,\n            \"inactive_file\": 28925952,\n            \"mapped_file\": 0,\n            \"pgfault\": 303666,\n            \"pgmajfault\": 0,\n            \"pgpgin\": 199749,\n            \"pgpgout\": 161965,\n            \"rss\": 98402304,\n            \"rss_huge\": 0,\n            \"total_active_anon\": 0,\n            \"total_active_file\": 27439104,\n            \"total_cache\": 56365056,\n            \"total_dirty\": 0,\n            \"total_inactive_anon\": 98267136,\n            \"total_inactive_file\": 28925952,\n            \"total_mapped_file\": 0,\n            \"total_pgfault\": 303666,\n            \"total_pgmajfault\": 0,\n            \"total_pgpgin\": 199749,\n            \"total_pgpgout\": 161965,\n            \"total_rss\": 98402304,\n            \"total_rss_huge\": 0,\n            \"total_unevictable\": 0,\n            \"total_writeback\": 135168,\n            \"unevictable\": 0,\n            \"writeback\": 135168\n        },\n        \"usage\": 168361984\n    },\n    \"name\": \"simple-user-app\",\n    \"networks\": {\n        \"eth1\": {\n            \"rx_bytes\": 1604876131,\n            \"rx_dropped\": 0,\n            \"rx_errors\": 0,\n            \"rx_packets\": 1076062,\n            \"tx_bytes\": 6252490,\n            \"tx_dropped\": 0,\n            \"tx_errors\": 0,\n            \"tx_packets\": 74457\n        }\n    },\n    \"num_procs\": 0,\n    \"pids_stats\": {},\n    \"precpu_stats\": {\n        \"cpu_usage\": {\n            \"percpu_usage\": [\n                5570558410,\n                5925648831\n            ],\n            \"total_usage\": 15328276321,\n            \"usage_in_kernelmode\": 2140000000,\n            \"usage_in_usermode\": 7970000000\n        },\n        \"online_cpus\": 2,\n        \"throttling_data\": {\n            \"periods\": 0,\n            \"throttled_periods\": 0,\n            \"throttled_time\": 0\n        }\n    },\n    \"preread\": \"2023-05-30T11:29:20.720196524Z\",\n    \"read\": \"2023-05-30T11:29:30.719936356Z\",\n    \"storage_stats\": {}\n}\n";
        JSONObject o = new JSONObject(stats);
        JSONObject precpu_stats = o.getJSONObject("precpu_stats");
        JSONObject cpu_stats = o.getJSONObject("cpu_stats");
        JSONObject memory_stats = o.getJSONObject("memory_stats");
        AwsEcsClientThread awsEcsClientThread = AwsEcsClientThread.getInstance();
        long system_cpu_usage = awsEcsClientThread.delta(precpu_stats, cpu_stats, "system_cpu_usage");
        JSONObject precpu_usage = precpu_stats.getJSONObject("cpu_usage");
        JSONObject cpu_usage = cpu_stats.getJSONObject("cpu_usage");
        long usage_tot = awsEcsClientThread.delta(precpu_usage, cpu_usage, "total_usage");
        long usage_sys = awsEcsClientThread.delta(precpu_usage, cpu_usage, "usage_in_kernelmode");
        long usage_usr = awsEcsClientThread.delta(precpu_usage, cpu_usage, "usage_in_usermode");
        float cpu = (float)usage_tot * 100.0f / (float)system_cpu_usage;
        float cpu_sys = (float)usage_sys * 100.0f / (float)system_cpu_usage;
        float cpu_user = (float)usage_usr * 100.0f / (float)system_cpu_usage;
        long mem_usage = memory_stats.getLong("usage");
        long mem_limit = memory_stats.getLong("limit");
        float mem_pct = (float)mem_usage * 100.0f / (float)mem_limit;
        System.out.println("cpu: " + cpu);
        System.out.println("cpu_sys: " + cpu_sys);
        System.out.println("cpu_user: " + cpu_user);
        System.out.println("mem_usage: " + mem_usage);
        System.out.println("mem_limit: " + mem_limit);
        System.out.println("mem_pct: " + mem_pct);
        System.out.println("usage_tot: " + usage_tot);
        System.out.println("usage_sys: " + usage_sys);
        System.out.println("usage_usr: " + usage_usr);
    }
}

