/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.task.res;

import java.io.File;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.conf.ConfSysMon;
import whatap.agent.counter.ICounterTask;
import whatap.agent.counter.meter.ThreadDump;
import whatap.agent.data.DataPackSender;
import whatap.agent.open.OpenMxEng;
import whatap.agent.proxy.IOshi;
import whatap.agent.proxy.OshiFactory;
import whatap.agent.trace.Alert;
import whatap.lang.pack.CounterPack1;
import whatap.lang.pack.TagCountPack;
import whatap.lang.value.MapValue;
import whatap.oshi.Cpu;
import whatap.util.DeferedRun;
import whatap.util.FileUtil;
import whatap.util.StringUtil;

public class SystemOshiTask
implements ICounterTask {
    private IOshi oshi;
    private DeferedRun<Float> disk = new DeferedRun<Float>(new DeferedRun.Exec<Float>(){

        @Override
        public Float call() {
            return Float.valueOf(SystemOshiTask.this.oshi.disk(ConfSysMon.oshi_disk_path));
        }
    }, ConfSysMon.oshi_disk_interval, Float.valueOf(0.0f));
    private long last_over_start;
    static int err = 20;
    static long lastProcCpuTime = 0L;
    static long lastTime = 0L;
    private static final double millistime = 1000.0;

    public SystemOshiTask() {
        this.oshi = OshiFactory.create();
    }

    public void process(CounterPack1 p) {
        block11: {
            block10: {
                try {
                    this.doProcess(p);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Configure conf = Configure.getInstance();
                if (conf.thread_dump_enabled && conf.thread_dump_cpu > 0 && p.cpu > (float)conf.thread_dump_cpu) {
                    ThreadDump.trigger();
                }
                if (ConfSysMon.oshi_network_enabled) {
                    try {
                        TagCountPack p2 = this.oshi.network();
                        if (p2 != null) {
                            p2.time = p.time;
                            DataPackSender.send(p2);
                        }
                    }
                    catch (Throwable t) {
                        if (err-- <= 0) break block10;
                        Logger.println(t.toString(), t);
                    }
                }
            }
            if (ConfSysMon.oshi_plugin_enabled) {
                try {
                    this.oshi.loadPlugin();
                }
                catch (Throwable t) {
                    if (err-- <= 0) break block11;
                    Logger.println(t.toString(), t);
                }
            }
        }
    }

    private void doProcess(CounterPack1 p) {
        if (this.oshi == null) {
            return;
        }
        long now = System.currentTimeMillis();
        Cpu vc = this.oshi.getCpu();
        if (vc != null) {
            p.cpu = vc.total * ConfSysMon.correction_factor_cpu;
            p.cpu_sys = vc.sys;
            p.cpu_usr = vc.user;
            p.cpu_wait = vc.wait;
            p.cpu_steal = vc.stolen;
            p.cpu_irq = vc.irq;
        }
        if (ConfSysMon.cpu_event_enabled) {
            if (p.cpu >= (float)ConfSysMon.cpu_event_percent) {
                if (this.last_over_start == 0L) {
                    this.last_over_start = now;
                }
            } else {
                this.last_over_start = 0L;
            }
            if (this.last_over_start > 0L && now - this.last_over_start >= (long)ConfSysMon.cpu_event_duration) {
                Alert.heapRate(p.cpu);
                this.last_over_start = 0L;
            }
        }
        int pid = this.oshi.pid();
        p.cpu_proc = ConfSysMon.oshi_proc_cpu_from_sysfile ? SystemOshiTask.getProcCpu(pid) : this.oshi.procCpu(pid);
        if (ConfSysMon.oshi_disk_enabled) {
            this.disk.setInterval(ConfSysMon.oshi_disk_interval);
            p.disk = this.disk.call().floatValue();
        }
        if (ConfSysMon.disk_event_enabled && p.disk >= (float)ConfSysMon.disk_event_percent) {
            Alert.diskRate(p.disk);
        }
        p.mem = this.oshi.mem();
        p.swap = this.oshi.swap();
        if (ConfSysMon.oshi_proc_mem_enabled) {
            long rss = this.oshi.procMemRss(pid);
            p.extra = new MapValue();
            p.extra.put("proc_mem_rss", rss);
            OpenMxEng.process_memory_bytes = rss;
        }
    }

    static float getProcCpu(int pid) {
        try {
            int ncpu = Runtime.getRuntime().availableProcessors();
            long now = System.currentTimeMillis();
            File file = new File("/proc/" + pid + "/stat");
            if (!file.exists()) {
                return 0.0f;
            }
            byte[] b = FileUtil.readAll(file);
            if (b == null) {
                return 0.0f;
            }
            String s = new String(b);
            String[] words = StringUtil.tokenizer(s, " ");
            long uCpuTime = Long.parseLong(words[13]);
            long sCpuTime = Long.parseLong(words[14]);
            long totCpuTime = (uCpuTime += Long.parseLong(words[15])) + (sCpuTime += Long.parseLong(words[16]));
            long oldCpuTime = lastProcCpuTime;
            long scClkTck = 100L;
            double timediff = now - lastTime;
            lastTime = now;
            lastProcCpuTime = totCpuTime;
            if (oldCpuTime > 0L && timediff > 0.0) {
                return (float)(100.0 * (double)(totCpuTime - oldCpuTime) / (double)scClkTck / (timediff / 1000.0)) / (float)ncpu;
            }
        }
        catch (Exception e) {
            Logger.println("OSHI", " procCpu from Linux /proc: " + e);
        }
        return 0.0f;
    }
}

