/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.task.pools.other;

import java.lang.management.ManagementFactory;
import java.util.Set;
import java.util.TreeSet;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import whatap.agent.Logger;
import whatap.agent.data.DataTextAgent;
import whatap.lang.value.ListValue;
import whatap.lang.value.MapValue;
import whatap.util.CastUtil;
import whatap.util.HashUtil;
import whatap.util.IntIntMap;
import whatap.util.StringUtil;
import whatap.util.SysJMX;

public class WebLogicDS10 {
    public static MBeanServer mserver = null;
    static long enable_time = SysJMX.getStartTime() + 300000L;
    static Set<ObjectName> targetObjectNames = null;

    public static void getJDBCRuntime(MapValue result, String fContext, String fName, String fKey) throws Exception {
        ListValue contextLv = result.newList("context");
        ListValue nameLv = result.newList("name");
        ListValue keyLv = result.newList("key");
        ListValue valueLv = result.newList("value");
        if (targetObjectNames == null) {
            return;
        }
        if (mserver == null) {
            WebLogicDS10.createMBeanSErver();
        }
        boolean hasFilter = StringUtil.isNotEmpty(fContext) || StringUtil.isNotEmpty(fName) || StringUtil.isNotEmpty(fKey);
        Set<ObjectName> ds = targetObjectNames;
        for (ObjectName o : ds) {
            String ctx = o.toString();
            String name = o.getKeyProperty("Name");
            MBeanInfo f = mserver.getMBeanInfo(o);
            MBeanAttributeInfo[] af = f.getAttributes();
            for (int i = 0; i < af.length; ++i) {
                String k = af[i].getName();
                Object v = mserver.getAttribute(o, k);
                if (hasFilter && (!WebLogicDS10.has(ctx, fContext) || !WebLogicDS10.has(name, fName) || !WebLogicDS10.has(k, fKey))) continue;
                contextLv.add(ctx);
                nameLv.add(name);
                keyLv.add(af[i].getName());
                valueLv.add(CastUtil.cString(v));
            }
        }
    }

    private static boolean has(String k, String filter) {
        if (StringUtil.isEmpty(filter)) {
            return true;
        }
        return k.contains(filter);
    }

    private static void search() {
        targetObjectNames = new TreeSet<ObjectName>();
        try {
            if (mserver == null) {
                WebLogicDS10.createMBeanSErver();
            }
            Set<ObjectName> ds = mserver.queryNames(null, new ObjectName("com.bea:*"));
            for (ObjectName o : ds) {
                try {
                    String objStr = o.toString();
                    if (objStr.indexOf("JDBCConnectionPoolRuntime") < 0) continue;
                    try {
                        Object r = mserver.getAttribute(o, "NumAvailable");
                        targetObjectNames.add(o);
                    }
                    catch (Exception ee) {
                        if (System.getProperty("whatap.weblogic.e004") == null) {
                            System.setProperty("whatap.weblogic.e004", o.toString() + " " + ee.toString());
                        }
                        throw ee;
                    }
                }
                catch (Exception exception) {
                }
            }
        }
        catch (Exception e) {
            System.setProperty("whatap.weblogic.e003", e.toString());
        }
    }

    public static void process(IntIntMap db_num_active, IntIntMap db_num_idle) {
        if (System.currentTimeMillis() < enable_time) {
            return;
        }
        try {
            if (targetObjectNames == null) {
                WebLogicDS10.search();
            }
            if (mserver == null) {
                WebLogicDS10.createMBeanSErver();
            }
            for (ObjectName o : targetObjectNames) {
                String poolName = (String)mserver.getAttribute(o, "Name");
                int hash = HashUtil.hash(poolName);
                DataTextAgent.dbc(hash, poolName);
                int active = CastUtil.cint(mserver.getAttribute(o, "NumUnavailable"));
                int idle = CastUtil.cint(mserver.getAttribute(o, "NumAvailable"));
                db_num_active.add(hash, active);
                db_num_idle.add(hash, idle);
            }
        }
        catch (Exception e) {
            Logger.println("WebLogicDS10", 3600000, e.toString());
        }
    }

    private static void createMBeanSErver() {
        mserver = ManagementFactory.getPlatformMBeanServer();
    }
}

