/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.task.pools;

import java.lang.ref.WeakReference;
import java.util.Enumeration;
import whatap.agent.Logger;
import whatap.agent.conf.ConfPool;
import whatap.agent.control.ds.DBPoolClassUtil;
import whatap.agent.counter.task.pools.CNT;
import whatap.agent.counter.task.pools.PoolObjectReflect;
import whatap.agent.data.DataTextAgent;
import whatap.agent.plugin.PluginCunstomPool;
import whatap.agent.plugin.WrDBPoolResult;
import whatap.agent.trace.ConPool;
import whatap.util.AnsiPrint;
import whatap.util.HashUtil;
import whatap.util.IntIntMap;
import whatap.util.StringKeyLinkedMap;
import whatap.util.StringUtil;

public class UserDefinedDbPool {
    static StringKeyLinkedMap<CNT> detail = new StringKeyLinkedMap<CNT>(){

        @Override
        protected CNT create(String key) {
            return new CNT();
        }
    };

    public static void process(String poolName, IntIntMap db_num_active, IntIntMap db_num_idle) {
        if (ConfPool.pool_detail_enabled) {
            detail.clear();
        }
        try {
            int poolHash = HashUtil.hash(poolName);
            DataTextAgent.dbc(poolHash, poolName);
            Enumeration<WeakReference<Object>> poolEnum = ConPool.getObjectEnum(poolName);
            while (poolEnum.hasMoreElements()) {
                Object pool = poolEnum.nextElement().get();
                if (pool == null) continue;
                if (ConfPool.custom_pool_id != null && ConfPool.custom_pool_id.equals(poolName)) {
                    String name = poolName;
                    int nameHash = poolHash;
                    try {
                        String id;
                        if (ConfPool.custom_pool_method_name != null && (id = PoolObjectReflect.getStringNoException(pool, ConfPool.custom_pool_method_name)) != null) {
                            name = id;
                            nameHash = HashUtil.hash(id);
                            DataTextAgent.dbc(nameHash, id);
                        }
                        int active = 0;
                        int idle = 0;
                        int total = 0;
                        if (StringUtil.isNotEmpty(ConfPool.custom_pool_method_active)) {
                            active = PoolObjectReflect.getInt(pool, ConfPool.custom_pool_method_active);
                        }
                        if (StringUtil.isNotEmpty(ConfPool.custom_pool_method_total)) {
                            total = PoolObjectReflect.getInt(pool, ConfPool.custom_pool_method_total);
                        }
                        if (total > 0) {
                            idle = total - active;
                        } else if (StringUtil.isNotEmpty(ConfPool.custom_pool_method_idle)) {
                            idle = PoolObjectReflect.getInt(pool, ConfPool.custom_pool_method_idle);
                        }
                        db_num_active.add(nameHash, active);
                        db_num_idle.add(nameHash, idle);
                        if (!ConfPool.pool_detail_enabled) continue;
                        detail.intern(name).add(active, idle);
                    }
                    catch (Throwable e) {
                        Logger.println("UserDefinedDbPool", 3600000, AnsiPrint.green(e + ",hotfix: remove custom_pool_id=" + ConfPool.custom_pool_id));
                    }
                    continue;
                }
                WrDBPoolResult result = new WrDBPoolResult();
                PluginCunstomPool.process(poolName, pool, result);
                if (result.active >= 0) {
                    db_num_active.add(poolHash, result.active);
                }
                if (result.idle >= 0) {
                    db_num_idle.add(poolHash, result.idle);
                }
                if (!ConfPool.pool_detail_enabled) continue;
                String name = result.name == null ? poolName : result.name;
                detail.intern(name).add(result.active, result.idle);
            }
            if (ConfPool.pool_detail_enabled) {
                DBPoolClassUtil.poolDetail(poolName, detail);
            }
        }
        catch (Throwable e) {
            Logger.println("UserDefinedDBPool", 10, e.toString());
        }
    }
}

