/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.task.pools;

import java.lang.ref.WeakReference;
import java.util.Enumeration;
import whatap.agent.Logger;
import whatap.agent.conf.ConfPool;
import whatap.agent.control.ds.DBPoolClassUtil;
import whatap.agent.counter.task.pools.CNT;
import whatap.agent.counter.task.pools.IConnPoolObject;
import whatap.agent.counter.task.pools.PoolObjectReflect;
import whatap.agent.data.DataTextAgent;
import whatap.agent.trace.ConPool;
import whatap.util.HashUtil;
import whatap.util.IntIntLinkedMap;
import whatap.util.IntIntMap;
import whatap.util.IntKeyLinkedMap;
import whatap.util.IntLongLinkedMap;
import whatap.util.StringKeyLinkedMap;

public class JBossDataSourcePool
implements IConnPoolObject {
    public static String className = "JBossDataSourcePool";
    static int classNameHash = HashUtil.hash(className);
    private static IntIntLinkedMap nameMap = new IntIntLinkedMap().setMax(1000);
    private static IntKeyLinkedMap<String> nameStrMap = new IntKeyLinkedMap().setMax(500);
    private static IntLongLinkedMap checkMap = new IntLongLinkedMap().setMax(1000);
    private static int argsErrCnt = 10;
    private static IntKeyLinkedMap<MethodCache> methodCacheMap = new IntKeyLinkedMap().setMax(500);
    private static IntLongLinkedMap cacheTimestampMap = new IntLongLinkedMap().setMax(500);
    private static final long STARTUP_PERIOD = 300000L;
    private static final long MILLIS_PER_DAY = 86400000L;
    private static final long startupTime = System.currentTimeMillis();
    private static long lastResetTime = System.currentTimeMillis();
    private static final int MAX_RETRIES = 3;

    public String id() {
        return className;
    }

    public boolean process(IntIntMap db_num_active, IntIntMap db_num_idle) {
        if (!ConfPool.jboss_datasource_pool_enabled) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (now - lastResetTime > 86400000L) {
            this.resetOldCacheEntries(now - 86400000L);
            lastResetTime = now;
        }
        StringKeyLinkedMap<CNT> detail = null;
        if (ConfPool.pool_detail_enabled) {
            detail = new StringKeyLinkedMap<CNT>(){

                @Override
                protected CNT create(String key) {
                    return new CNT();
                }
            };
        }
        try {
            Enumeration<WeakReference<Object>> poolEnum = ConPool.getObjectEnum(className);
            if (poolEnum == null) {
                return false;
            }
            while (poolEnum.hasMoreElements()) {
                Object dataSource;
                WeakReference<Object> ref = poolEnum.nextElement();
                if (ref == null || (dataSource = ref.get()) == null) continue;
                try {
                    String name;
                    Object poolStatisticsImplObject;
                    int nameHash;
                    block17: {
                        int oHash = System.identityHashCode(dataSource);
                        nameHash = nameMap.get(oHash);
                        if (nameHash == 0) {
                            long last = checkMap.get(oHash);
                            if (now - last <= 21600000L) continue;
                            String poolName = this.resolvePoolName(dataSource);
                            if (poolName == null) {
                                Logger.println(className, 60000, "cannot extract pool name, hotfix: jboss_datasource_pool_enabled=false");
                                continue;
                            }
                            nameHash = HashUtil.hash(poolName);
                            DataTextAgent.dbc(nameHash, poolName);
                            nameStrMap.put(nameHash, poolName);
                            nameMap.put(oHash, nameHash);
                            checkMap.put(oHash, now);
                        }
                        poolStatisticsImplObject = null;
                        try {
                            poolStatisticsImplObject = PoolObjectReflect.getObject(dataSource, "getStatistics");
                        }
                        catch (NoSuchMethodException e) {
                            if (Logger.checkOk(className + ".getStatistics", 60)) {
                                Logger.println(className, 60000, "DataSource has no getStatistics method: " + dataSource.getClass().getName() + ", hotfix: jboss_datasource_pool_enabled=false");
                            }
                        }
                        catch (Throwable e) {
                            if (!Logger.checkOk(className, 10) || argsErrCnt <= 0) break block17;
                            --argsErrCnt;
                            Logger.println(className, 3600000, e.getMessage() + ", hotfix: jboss_datasource_pool_enabled=false");
                        }
                    }
                    if (poolStatisticsImplObject == null) continue;
                    int act = this.getActiveConnectionsCount(dataSource, poolStatisticsImplObject);
                    int idle = this.getIdleConnectionsCount(dataSource, poolStatisticsImplObject);
                    db_num_active.add(nameHash, act);
                    db_num_idle.add(nameHash, idle);
                    if (!ConfPool.pool_detail_enabled || detail == null || (name = nameStrMap.get(nameHash)) == null) continue;
                    ((CNT)detail.intern(name)).add(act, idle);
                    if (!ConfPool.debug_pool_detail_enabled) continue;
                    Logger.println("DBPOOL", className + ": pool=" + name + " act=" + act + " idle=" + idle);
                }
                catch (Throwable e) {
                    if (!Logger.checkOk(className, 10) || argsErrCnt <= 0) continue;
                    --argsErrCnt;
                    Logger.println(className, 3600000, "DataSource processing error: " + e.getMessage() + ", hotfix: jboss_datasource_pool_enabled=false");
                }
            }
            if (ConfPool.pool_detail_enabled && detail != null) {
                DBPoolClassUtil.poolDetail(className, detail);
            }
            return true;
        }
        catch (Throwable e) {
            if (Logger.checkOk(className, 10) && argsErrCnt > 0) {
                --argsErrCnt;
                Logger.println(className, 3600000, e.getMessage() + ", hotfix: jboss_datasource_pool_enabled=false");
            }
            return false;
        }
    }

    private String resolvePoolName(Object dataSource) {
        String poolName;
        block5: {
            poolName = null;
            try {
                Object pool = PoolObjectReflect.getObject(dataSource, "getPool");
                if (pool != null) {
                    poolName = PoolObjectReflect.getStringNoException(pool, "getName");
                }
            }
            catch (Throwable e) {
                if (!Logger.checkOk(className + ".getPool", 60)) break block5;
                Logger.println(className, 60000, "getPool: " + e.getMessage() + ", hotfix: jboss_datasource_pool_enabled=false");
            }
        }
        if (poolName == null || poolName.isEmpty()) {
            poolName = PoolObjectReflect.getStringNoException(dataSource, "getJndiName");
        }
        if (poolName == null || poolName.isEmpty()) {
            poolName = dataSource.getClass().getName();
        }
        return poolName;
    }

    private int getActiveConnectionsCount(Object dataSource, Object statisticsObject) {
        int act;
        MethodCache cache;
        block20: {
            boolean isStartup;
            block19: {
                int dsHash = System.identityHashCode(dataSource);
                cache = methodCacheMap.get(dsHash);
                if (cache == null) {
                    cache = new MethodCache();
                    methodCacheMap.put(dsHash, cache);
                    cacheTimestampMap.put(dsHash, System.currentTimeMillis());
                }
                if (cache.isOldImpl) {
                    block18: {
                        if (cache.hasGetActiveCount == Boolean.TRUE) {
                            try {
                                return PoolObjectReflect.getInt(statisticsObject, "getActiveCount");
                            }
                            catch (Throwable e) {
                                if (!Logger.checkOk(className + ".getActiveCount", 60)) break block18;
                                Logger.println(className, 60000, "getActiveCount: " + e.getMessage() + ", hotfix: jboss_datasource_pool_enabled=false");
                            }
                        }
                    }
                    return 0;
                }
                isStartup = System.currentTimeMillis() - startupTime < 300000L;
                act = 0;
                if (cache.hasGetInUseCount != Boolean.FALSE) {
                    try {
                        act = PoolObjectReflect.getInt(statisticsObject, "getInUseCount");
                        cache.hasGetInUseCount = Boolean.TRUE;
                        return act;
                    }
                    catch (NoSuchMethodException e) {
                        if (isStartup && cache.inUseCountRetries < 3) {
                            ++cache.inUseCountRetries;
                        } else {
                            cache.hasGetInUseCount = Boolean.FALSE;
                        }
                    }
                    catch (Throwable e) {
                        if (!Logger.checkOk(className, 10) || argsErrCnt <= 0) break block19;
                        --argsErrCnt;
                        Logger.println(className, 3600000, "getInUseCount: " + e.getMessage() + ", hotfix: jboss_datasource_pool_enabled=false");
                    }
                }
            }
            if (cache.hasGetActiveCount != Boolean.FALSE) {
                try {
                    act = PoolObjectReflect.getInt(statisticsObject, "getActiveCount");
                    cache.hasGetActiveCount = Boolean.TRUE;
                    return act;
                }
                catch (NoSuchMethodException e) {
                    if (isStartup && cache.activeCountRetries < 3) {
                        ++cache.activeCountRetries;
                    } else {
                        cache.hasGetActiveCount = Boolean.FALSE;
                    }
                }
                catch (Throwable e) {
                    if (!Logger.checkOk(className, 10) || argsErrCnt <= 0) break block20;
                    --argsErrCnt;
                    Logger.println(className, 3600000, "getActiveCount: " + e.getMessage() + ", hotfix: jboss_datasource_pool_enabled=false");
                }
            }
        }
        if (cache.hasGetInUseCount == Boolean.FALSE && cache.hasGetActiveCount == Boolean.FALSE) {
            cache.isOldImpl = true;
        }
        return act;
    }

    private int getIdleConnectionsCount(Object dataSource, Object statistics) {
        int idle;
        MethodCache cache;
        block20: {
            boolean isStartUpPeriod;
            block19: {
                int dsHash = System.identityHashCode(dataSource);
                cache = methodCacheMap.get(dsHash);
                if (cache == null) {
                    cache = new MethodCache();
                    methodCacheMap.put(dsHash, cache);
                    cacheTimestampMap.put(dsHash, System.currentTimeMillis());
                }
                if (cache.isOldImpl) {
                    block18: {
                        if (cache.hasGetAvailableCount == Boolean.TRUE) {
                            try {
                                return PoolObjectReflect.getInt(statistics, "getAvailableCount");
                            }
                            catch (Throwable e) {
                                if (!Logger.checkOk(className + ".getAvailableCount", 60)) break block18;
                                Logger.println(className, 60000, "getAvailableCount: " + e.getMessage() + ", hotfix: jboss_datasource_pool_enabled=false");
                            }
                        }
                    }
                    return 0;
                }
                isStartUpPeriod = System.currentTimeMillis() - startupTime < 300000L;
                idle = 0;
                if (cache.hasGetIdleCount != Boolean.FALSE) {
                    try {
                        idle = PoolObjectReflect.getInt(statistics, "getIdleCount");
                        cache.hasGetIdleCount = Boolean.TRUE;
                        return idle;
                    }
                    catch (NoSuchMethodException e) {
                        if (isStartUpPeriod && cache.idleCountRetries < 3) {
                            ++cache.idleCountRetries;
                        } else {
                            cache.hasGetIdleCount = Boolean.FALSE;
                        }
                    }
                    catch (Throwable e) {
                        if (!Logger.checkOk(className, 10) || argsErrCnt <= 0) break block19;
                        --argsErrCnt;
                        Logger.println(className, 3600000, "getIdleCount: " + e.getMessage() + ", hotfix: jboss_datasource_pool_enabled=false");
                    }
                }
            }
            if (cache.hasGetAvailableCount != Boolean.FALSE) {
                try {
                    idle = PoolObjectReflect.getInt(statistics, "getAvailableCount");
                    cache.hasGetAvailableCount = Boolean.TRUE;
                    return idle;
                }
                catch (NoSuchMethodException e) {
                    if (isStartUpPeriod && cache.availableCountRetries < 3) {
                        ++cache.availableCountRetries;
                    } else {
                        cache.hasGetAvailableCount = Boolean.FALSE;
                    }
                }
                catch (Throwable e) {
                    if (!Logger.checkOk(className, 10) || argsErrCnt <= 0) break block20;
                    --argsErrCnt;
                    Logger.println(className, 3600000, "getAvailableCount: " + e.getMessage() + ", hotfix: jboss_datasource_pool_enabled=false");
                }
            }
        }
        if (cache.hasGetIdleCount == Boolean.FALSE && cache.hasGetAvailableCount == Boolean.FALSE) {
            cache.isOldImpl = true;
        }
        return idle;
    }

    private void resetOldCacheEntries(long cutoffTime) {
        int resetCount = 0;
        int[] keys = cacheTimestampMap.keyArray();
        if (keys == null) {
            return;
        }
        for (int i = 0; i < keys.length; ++i) {
            MethodCache cache;
            int key = keys[i];
            long timestamp = cacheTimestampMap.get(key);
            if (timestamp >= cutoffTime || (cache = methodCacheMap.get(key)) == null) continue;
            cache.inUseCountRetries = 0;
            cache.activeCountRetries = 0;
            cache.idleCountRetries = 0;
            cache.availableCountRetries = 0;
            cache.hasGetInUseCount = null;
            cache.hasGetActiveCount = null;
            cache.hasGetIdleCount = null;
            cache.hasGetAvailableCount = null;
            cache.isOldImpl = false;
            cacheTimestampMap.put(key, System.currentTimeMillis());
            ++resetCount;
        }
        if (ConfPool.debug_pool_detail_enabled) {
            Logger.println("DBPOOL", className + ": Cache reset completed. Reset entries: " + resetCount);
        }
    }

    private static class MethodCache {
        Boolean hasGetInUseCount = null;
        Boolean hasGetActiveCount = null;
        Boolean hasGetIdleCount = null;
        Boolean hasGetAvailableCount = null;
        int inUseCountRetries = 0;
        int activeCountRetries = 0;
        int idleCountRetries = 0;
        int availableCountRetries = 0;
        boolean isOldImpl = false;

        private MethodCache() {
        }
    }
}

