/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.task.pools;

import java.lang.ref.WeakReference;
import java.util.Enumeration;
import whatap.agent.Logger;
import whatap.agent.conf.ConfPool;
import whatap.agent.control.ds.DBPoolClassUtil;
import whatap.agent.counter.task.pools.CNT;
import whatap.agent.counter.task.pools.IConnPoolObject;
import whatap.agent.counter.task.pools.PoolObjectReflect;
import whatap.agent.data.DataTextAgent;
import whatap.agent.trace.ConPool;
import whatap.util.HashUtil;
import whatap.util.IntIntMap;
import whatap.util.StringKeyLinkedMap;

public class HbyrisDataSourcePool
implements IConnPoolObject {
    public static String className = "HbyrisDataSourcePool";
    static int classNameHash = HashUtil.hash(className);

    public String id() {
        return className;
    }

    public boolean process(IntIntMap db_num_active, IntIntMap db_num_idle) {
        if (!ConfPool.hybris_pool_enabled) {
            return false;
        }
        StringKeyLinkedMap<CNT> detail = new StringKeyLinkedMap<CNT>(){

            @Override
            protected CNT create(String key) {
                return new CNT();
            }
        };
        try {
            Enumeration<WeakReference<Object>> poolEnum = ConPool.getObjectEnum(className);
            while (poolEnum.hasMoreElements()) {
                int poolHash;
                Object pool = poolEnum.nextElement().get();
                if (pool == null) continue;
                String name = PoolObjectReflect.getStringNoException(pool, "getID");
                if (name != null) {
                    poolHash = HashUtil.hash(name);
                    DataTextAgent.dbc(poolHash, name);
                } else {
                    poolHash = classNameHash;
                    name = className;
                    DataTextAgent.dbc(classNameHash, className);
                }
                int act = PoolObjectReflect.getInt(pool, "getNumInUse");
                int idle = PoolObjectReflect.getInt(pool, "getMaxAllowedPhysicalOpen");
                db_num_active.add(poolHash, act);
                db_num_idle.add(poolHash, idle);
                if (!ConfPool.pool_detail_enabled) continue;
                ((CNT)detail.intern(name)).add(act, idle);
                if (!ConfPool.debug_pool_detail_enabled) continue;
                Logger.println("DBPOOL", className + ": pool=" + name + " act=" + act + " idle=" + idle);
            }
            if (ConfPool.pool_detail_enabled) {
                DBPoolClassUtil.poolDetail(className, detail);
            }
            return true;
        }
        catch (Throwable e) {
            Logger.println("HyrisDataSourcePool", 3600000, e + ",hotfix: hybris_pool_enabled=false");
            return false;
        }
    }
}

