/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.task;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Enumeration;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.conf.ConfActiveStack;
import whatap.agent.conf.ConfApdex;
import whatap.agent.conf.ConfDebug;
import whatap.agent.conf.ConfLogSink;
import whatap.agent.conf.ConfOpenMx;
import whatap.agent.conf.ConfTrace;
import whatap.agent.counter.ICounterTask;
import whatap.agent.counter.meter.MeterActiveX;
import whatap.agent.counter.meter.MeterTpsResp;
import whatap.agent.counter.meter.tx.BucketService;
import whatap.agent.counter.meter.tx.MeterService;
import whatap.agent.counter.meter.tx.MeterServiceBackground;
import whatap.agent.data.DataPackSender;
import whatap.agent.open.OpenMxEng;
import whatap.agent.trace.MTraceHelper;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.TraceSamplingManager;
import whatap.agent.trace.exception.ExceptionAlert;
import whatap.lang.PKIND;
import whatap.lang.POID;
import whatap.lang.pack.AbstractPack;
import whatap.lang.pack.CounterPack1;
import whatap.lang.pack.HitMapPack1;
import whatap.lang.slog.SLog;
import whatap.logsink.LineLog;
import whatap.logsink.SenderUtil;
import whatap.logsink.std.StdErrSenderThread;
import whatap.logsink.std.StdOutSenderThread;
import whatap.util.DateUtil;
import whatap.util.IntKeyLinkedMap;
import whatap.util.LinkedMap;

public class ServiceTransaction
implements ICounterTask {
    float maxTps = 0.0f;
    Configure conf = Configure.getInstance();
    static MeterTpsResp avg30 = new MeterTpsResp();
    private static long lastArrival = 0L;

    public ServiceTransaction() {
        MeterService.getInstance();
        MeterServiceBackground.getInstance();
    }

    public void process(CounterPack1 p) {
        int tx_count;
        MeterService meterService = MeterService.getInstance();
        MeterServiceBackground meterServiceBackground = MeterServiceBackground.getInstance();
        BucketService service = meterService.getAndResetService();
        AbstractPack hitmap = null;
        if (this.conf.realtime_interval == 5000) {
            hitmap = meterService.getAndResetHitMap().getPack(p.time);
            DataPackSender.sendHitMap(hitmap);
            hitmap = meterServiceBackground.getAndResetHitMap().getPack(p.time);
            DataPackSender.sendHitMap(hitmap);
        }
        double addTxRate = 0.0;
        p.service_count = tx_count = service.count.get();
        if (tx_count > 0) {
            p.service_time_sum = service.timeSum;
            p.service_error = service.error;
            p.apdex_satisfied = service.count_satisfied;
            p.apdex_tolerated = service.count_tolerated;
            p.apdex_total = tx_count;
            if (ConfApdex.debug_apdex_enabled && p.apdex_satisfied + p.apdex_tolerated > p.apdex_total) {
                SLog sb = SLog.n("debug", "apdex");
                sb.a("s", p.apdex_satisfied, "t", p.apdex_tolerated, "c", p.apdex_total);
                sb.a("os", service.count_satisfied, "ot", service.count_tolerated, "oc", tx_count);
                sb.a("pcode", p.pcode, "oid", p.oid);
                Logger.println(sb.red());
            }
            p.tx_dbc_time = (float)service.dbcSum / (float)tx_count;
            p.tx_sql_time = (float)service.sqlSum / (float)tx_count;
            p.tx_httpc_time = (float)service.httpcSum / (float)tx_count;
            int overflow = 0;
            if (ConfTrace.trace_sampling_enabled) {
                overflow = TraceSamplingManager.getInstance().getCountAndReset();
                if (ConfTrace.debug_trace_sampling) {
                    Logger.println("trace_sampling_overflow=" + overflow);
                }
            }
            int profileOverflow = 0;
            if (overflow > 0 || profileOverflow > 0) {
                addTxRate = (double)(overflow + profileOverflow + p.service_count) / (double)p.service_count;
                p.service_count = (int)((double)p.service_count * addTxRate);
                p.service_error = (int)((double)p.service_error * addTxRate);
                p.service_time_sum = (long)((double)p.service_time_sum * addTxRate);
                p.apdex_satisfied = (int)((double)p.apdex_satisfied * addTxRate);
                p.apdex_tolerated = (int)((double)p.apdex_tolerated * addTxRate);
            }
        }
        if (this.conf.tx_caller_meter_enabled) {
            this.tx_caller_meter(p);
        }
        if (this.conf.actx_meter_enabled) {
            this.tx_caller_actx_meter(p);
        }
        double rtime = 0.0;
        if (p.collect_interval_ms > 0L) {
            double arrival = meterService.arrival - lastArrival;
            p.arrival_rate = (float)(arrival * 1000.0 / (double)p.collect_interval_ms);
            p.tps = (float)((double)tx_count * 1000.0 / (double)p.collect_interval_ms);
            rtime = tx_count == 0 ? 0.0 : (double)service.timeSum / (double)tx_count;
            p.resp_time = (int)rtime;
        }
        avg30.add(p.tps, rtime);
        if (this.conf.tps_avg30_enabled) {
            MeterTpsResp.Bucket bk = avg30.getAvg(30);
            p.tps = (float)bk.tps;
            p.resp_time = (int)bk.rtime;
        }
        lastArrival = meterService.arrival;
        if (ConfTrace.auto_trace_basetime) {
            ConfTrace.trace_basetime = p.tps < 20.0f ? 0 : (p.tps < 1000.0f ? 400 + (int)p.tps : 1500);
        }
        MTraceHelper.updateMtraceAutoRate(p.tps);
        if (ConfActiveStack.auto_active_stack_count) {
            this.maxTps = Math.max(this.maxTps, p.tps);
            ConfActiveStack.active_stack_count = this.maxTps < 100.0f ? 50 : (this.maxTps < 300.0f ? 30 : 20);
            if (this.maxTps > p.tps + 100.0f) {
                this.maxTps -= 10.0f;
            }
        }
        p.resp90 = -1;
        p.resp95 = -1;
        p.time_sqr_sum = service.time_sqr_sum;
        if (addTxRate > 1.0) {
            p.arrival_rate = (float)((double)p.arrival_rate * addTxRate);
            p.tps = (float)((double)p.tps * addTxRate);
            p.time_sqr_sum = (long)((double)p.time_sqr_sum * addTxRate);
        }
        if (ConfDebug.debug_tx_count_enabled && hitmap != null) {
            this.debug_tx_count(p, hitmap);
        }
        if (ConfLogSink.logsink_stdout_enabled) {
            StdOutSenderThread.getInstance();
        }
        if (ConfLogSink.logsink_stderr_enabled) {
            StdErrSenderThread.getInstance();
        }
        ExceptionAlert.resetIgnoreRecord();
        if (ConfOpenMx.openmx_enabled && hitmap instanceof HitMapPack1) {
            OpenMxEng.update(p);
        }
    }

    private void debug_tx_count(CounterPack1 p, AbstractPack hp) {
        HitMapPack1 h;
        int hitSum;
        if (hp instanceof HitMapPack1 && p.service_count != (hitSum = this.sum(h = (HitMapPack1)hp))) {
            RuntimeMXBean rmx = ManagementFactory.getRuntimeMXBean();
            LineLog log = new LineLog();
            log.time = DateUtil.now();
            log.category = "#AgentDebug";
            log.tags.put("title", "TX_COUNT_NOT_MATCH");
            log.tags.put("level", "critical");
            log.fields.put("hitmap", hitSum);
            log.fields.put("countPack", p.service_count);
            log.fields.put("uptime", rmx.getUptime());
            log.fields.put("servertime_delta", DateUtil.getServerDelta());
            log.fields.put("countpack_time", p.time);
            log.fields.put("countpack_time_str", DateUtil.timestamp(p.time));
            log.fields.put("countpack_delta", System.currentTimeMillis() - p.time);
            log.content = "Error HitMap=" + hitSum + " CountPack=" + p.service_count;
            SenderUtil.send(log);
            Logger.red(log.toString());
        }
    }

    private String[] toName(double[] r) {
        try {
            if (r == null) {
                return new String[0];
            }
            String[] o = new String[r.length];
            for (int i = 0; i < r.length; ++i) {
                o[i] = "p" + (int)(r[i] * 100.0);
            }
            return o;
        }
        catch (Throwable throwable) {
            return new String[0];
        }
    }

    private int sum(HitMapPack1 h) {
        int s = 0;
        for (int i = 0; i < h.hit.length; ++i) {
            s += h.hit[i];
        }
        return s;
    }

    private void tx_caller_meter(CounterPack1 p) {
        CounterPack1.TxMeter m;
        MeterService.BucketSimple b;
        int i;
        Enumeration<POID> en;
        MeterService meter = MeterService.getInstance();
        if (meter.statByOID.size() > 0) {
            p.txcaller_oid_meter = new IntKeyLinkedMap();
            en = meter.statByOID.keys();
            for (i = 0; i < 300 && en.hasMoreElements(); ++i) {
                int key = en.nextInt();
                b = meter.statByOID.get(key);
                m = new CounterPack1.TxMeter();
                m.time = b.timesum;
                m.count = b.count;
                m.error = b.error;
                p.txcaller_oid_meter.put(key, m);
            }
        }
        if (meter.statByPKIND.size() > 0) {
            p.txcaller_group_meter = new LinkedMap();
            en = meter.statByPKIND.keys();
            for (i = 0; i < 300 && en.hasMoreElements(); ++i) {
                PKIND key = (PKIND)((Object)en.nextElement());
                b = meter.statByPKIND.get(key);
                m = new CounterPack1.TxMeter();
                m.time = b.timesum;
                m.count = b.count;
                m.error = b.error;
                p.txcaller_group_meter.put(key, m);
            }
        }
        if (meter.statByPOID.size() > 0) {
            p.txcaller_poid_meter = new LinkedMap();
            en = meter.statByPOID.keys();
            for (i = 0; i < 300 && en.hasMoreElements(); ++i) {
                POID key = en.nextElement();
                b = meter.statByPOID.get(key);
                m = new CounterPack1.TxMeter();
                m.time = b.timesum;
                m.count = b.count;
                m.error = b.error;
                p.txcaller_poid_meter.put(key, m);
            }
        }
        if (meter.unknown != null && meter.unknown.count > 0) {
            if (p.txcaller_unknown == null) {
                p.txcaller_unknown = new CounterPack1.TxMeter();
            }
            p.txcaller_unknown.count = meter.unknown.count;
            p.txcaller_unknown.error = meter.unknown.error;
            p.txcaller_unknown.time = meter.unknown.timesum;
        }
        meter.resetStat();
        TraceContext.updatePOID();
    }

    private void tx_caller_actx_meter(CounterPack1 p) {
        CounterPack1.TxMeter m;
        int i;
        Enumeration<POID> en;
        MeterActiveX meter = MeterActiveX.getInstance();
        if (meter.statByOid == null) {
            return;
        }
        if (meter.statByOid.size() > 0) {
            if (p.txcaller_oid_meter == null) {
                p.txcaller_oid_meter = new IntKeyLinkedMap();
            }
            en = meter.statByOid.keys();
            for (i = 0; i < 300 && en.hasMoreElements(); ++i) {
                int key = en.nextInt();
                m = p.txcaller_oid_meter.get(key);
                if (m == null) {
                    m = new CounterPack1.TxMeter();
                    p.txcaller_oid_meter.put(key, m);
                }
                m.acts = meter.statByOid.get(key);
            }
        }
        if (meter.statByGroup.size() > 0) {
            if (p.txcaller_group_meter == null) {
                p.txcaller_group_meter = new LinkedMap();
            }
            en = meter.statByGroup.keys();
            for (i = 0; i < 300 && en.hasMoreElements(); ++i) {
                PKIND key = (PKIND)((Object)en.nextElement());
                m = p.txcaller_group_meter.get(key);
                if (m == null) {
                    m = new CounterPack1.TxMeter();
                    p.txcaller_group_meter.put(key, m);
                }
                m.acts = meter.statByGroup.get(key);
            }
        }
        if (meter.statByPoid.size() > 0) {
            if (p.txcaller_poid_meter == null) {
                p.txcaller_poid_meter = new LinkedMap();
            }
            en = meter.statByPoid.keys();
            for (i = 0; i < 300 && en.hasMoreElements(); ++i) {
                POID key = en.nextElement();
                m = p.txcaller_poid_meter.get(key);
                if (m == null) {
                    m = new CounterPack1.TxMeter();
                    p.txcaller_poid_meter.put(key, m);
                }
                m.acts = meter.statByPoid.get(key);
            }
        }
        if (meter.unknown != null && this.sum(meter.unknown) > 0) {
            if (p.txcaller_unknown == null) {
                p.txcaller_unknown = new CounterPack1.TxMeter();
            }
            p.txcaller_unknown.acts = meter.unknown;
        }
    }

    private int sum(short[] numArr) {
        int sum = 0;
        for (short n : numArr) {
            sum += n;
        }
        return sum;
    }
}

