/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.task;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import whatap.agent.Configure;
import whatap.agent.counter.ICounterTask;
import whatap.agent.data.DataPackSender;
import whatap.lang.pack.CounterPack1;
import whatap.lang.pack.EventPack;
import whatap.util.ArrayUtil;
import whatap.util.DateUtil;
import whatap.util.SystemUtil;

public class ResThreadCount
implements ICounterTask {
    ThreadMXBean tmb;
    long last_time = 0L;

    public void process(CounterPack1 p) {
        if (SystemUtil.IS_JAVA_IBM || SystemUtil.IS_WINDOWS) {
            return;
        }
        if (this.tmb == null) {
            this.tmb = ManagementFactory.getThreadMXBean();
        }
        if (this.tmb == null) {
            return;
        }
        p.thread_total_started = this.tmb.getTotalStartedThreadCount();
        p.thread_count = this.tmb.getThreadCount();
        p.thread_daemon = this.tmb.getDaemonThreadCount();
        p.thread_peak_count = this.tmb.getPeakThreadCount();
        if (SystemUtil.IS_JAVA_1_5) {
            return;
        }
        if (Configure.getInstance().detect_deadlock_enabled) {
            try {
                this.detectDeadLock();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void detectDeadLock() {
        long[] ids = this.tmb.findDeadlockedThreads();
        if (ArrayUtil.len(ids) > 0) {
            long now = DateUtil.now();
            if (now < this.last_time + 3600000L) {
                return;
            }
            this.last_time = now;
            EventPack e = new EventPack();
            e.title = "THREAD_DEADLOCK";
            e.level = (byte)30;
            e.status = 1;
            StringBuffer sb = new StringBuffer();
            sb.append("Thread deadlock occur, threads: ");
            for (int i = 0; i < ids.length && i < 3; ++i) {
                ThreadInfo t = this.tmb.getThreadInfo(ids[i]);
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(t.getThreadName()).append("[" + ids[i] + "]");
            }
            e.message = sb.toString();
            DataPackSender.send(e);
        }
    }
}

