/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.task;

import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.SecurityMaster;
import whatap.agent.conf.ConfLogSink;
import whatap.agent.conf.ConfSysMon;
import whatap.agent.counter.ICounterTask;
import whatap.agent.counter.task.res.SystemECSTask;
import whatap.agent.counter.task.res.SystemJMXTask;
import whatap.agent.counter.task.res.SystemKubeTask;
import whatap.agent.counter.task.res.SystemLinuxTask;
import whatap.agent.counter.task.res.SystemOshiTask;
import whatap.agent.counter.task.res.SystemShellTask;
import whatap.agent.counter.task.res.SystemSigarTask;
import whatap.agent.counter.task.res.util.AwsEcsClientThread;
import whatap.agent.kube.KubeClient;
import whatap.lang.conf.ConfObserver;
import whatap.lang.pack.CounterPack1;
import whatap.logsink.watch.WatchLogManager;
import whatap.util.SystemUtil;

public class ResSysCPU
implements ICounterTask {
    protected byte systype = 1;
    public static ICounterTask sysmon = new ICounterTask(){

        public void process(CounterPack1 p) {
        }
    };
    private boolean first = true;

    public void process(CounterPack1 p) {
        p.cpu_cores = Runtime.getRuntime().availableProcessors();
        p.metering = p.cpu_cores;
        p.host_ip = SecurityMaster.getInstance().IP;
        if (this.first) {
            try {
                this.update(Configure.getInstance());
                ConfObserver.add("ResSysCPU", new Runnable(){

                    public void run() {
                        ResSysCPU.this.update(Configure.getInstance());
                    }
                });
            }
            catch (Throwable t) {
                Logger.red("[ResSysCPU] " + t);
            }
            this.first = false;
        }
        sysmon.process(p);
    }

    private void init() {
        if (ConfLogSink.watchlog_enabled) {
            WatchLogManager.getInstance();
        }
        if (Configure.getInstance().WHATAP_MICRO_ENABLED) {
            KubeClient.getInstance();
        }
        if (ConfSysMon.aws_ecs_enabled) {
            AwsEcsClientThread.getInstance();
        }
    }

    private void update(Configure conf) {
        this.init();
        byte thisType = ConfSysMon.findType();
        if (this.systype == thisType) {
            return;
        }
        this.systype = thisType;
        switch (thisType) {
            case 2: {
                sysmon = new SystemECSTask();
                Logger.println("SysCpu", "System CPU collected by 'ECS' task");
                break;
            }
            case 3: {
                sysmon = new SystemKubeTask();
                Logger.println("SysCpu", "System CPU collected by 'KUBE' task");
                break;
            }
            case 4: {
                sysmon = new SystemLinuxTask();
                Logger.println("SysCpu", "System CPU collected by 'LNUX /proc/stat'");
                break;
            }
            case 5: {
                sysmon = new SystemJMXTask();
                Logger.println("SysCpu", "System CPU collected by 'JMX' task");
                break;
            }
            case 6: {
                sysmon = new SystemShellTask();
                Logger.println("SysCpu", "System CPU collected by 'Shell'");
                break;
            }
            case 7: {
                sysmon = new SystemSigarTask();
                Logger.println("SysCpu", "System CPU collected by 'Sigar'");
                break;
            }
            case 8: {
                if (SystemUtil.IS_JAVA_OVER8()) {
                    sysmon = new SystemOshiTask();
                    Logger.green("OSHI System CPU collected by 'OSHI'");
                    Logger.green("OSHI oshi_disk_enabled=" + ConfSysMon.oshi_disk_enabled);
                    Logger.green("OSHI oshi_disk_path=" + ConfSysMon.oshi_disk_path);
                    break;
                }
                sysmon = new SystemJMXTask();
                Logger.println("SysCpu", "System CPU collected by 'JMX' , OSHI load fail, under Java8");
                break;
            }
            default: {
                sysmon = new SystemJMXTask();
                Logger.println("SysCpu", "System CPU collected by 'JMX' task(none)");
            }
        }
    }
}

