/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.task;

import whatap.agent.counter.ICounterTask;
import whatap.lang.pack.CounterPack1;
import whatap.util.DateUtil;
import whatap.util.SysJMX;

public class ResProcCPU
implements ICounterTask {
    private long oldTimeMilli = 0L;
    private long oldCpuNano = 0L;

    public void process(CounterPack1 p) {
        if (!SysJMX.isProcessCPU()) {
            return;
        }
        long now = DateUtil.nanoToMillis();
        long cpuNano = SysJMX.getProcessCPUnano();
        if (this.oldCpuNano <= 0L) {
            this.oldTimeMilli = now;
            this.oldCpuNano = cpuNano;
            return;
        }
        long dTime = now - this.oldTimeMilli;
        long dCpu = cpuNano - this.oldCpuNano;
        this.oldCpuNano = cpuNano;
        this.oldTimeMilli = now;
        if (dTime > 0L) {
            p.cputime = dCpu / 1000L / dTime;
        }
    }
}

