/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.meter.tx;

import whatap.agent.Configure;
import whatap.agent.counter.meter.tx.BucketHitMap;
import whatap.agent.counter.meter.tx.BucketHitView;
import whatap.agent.counter.meter.tx.BucketService;
import whatap.lang.PKIND;
import whatap.lang.POID;
import whatap.lang.service.TxRecord;
import whatap.util.IntKeyLinkedMap;
import whatap.util.LinkedMap;

public class MeterService {
    private static MeterService inst;
    Configure conf = Configure.getInstance();
    private BucketService service;
    private BucketHitMap hitmap;
    public BucketSimple unknown = new BucketSimple();
    public IntKeyLinkedMap<BucketSimple> statByOID = new IntKeyLinkedMap<BucketSimple>(309, 1.0f){

        @Override
        protected BucketSimple create(int key) {
            return new BucketSimple();
        }
    }.setMax(307);
    public LinkedMap<PKIND, BucketSimple> statByPKIND = new LinkedMap<PKIND, BucketSimple>(309, 1.0f){

        @Override
        protected BucketSimple create(PKIND pkind) {
            return new BucketSimple();
        }
    }.setMax(307);
    public LinkedMap<POID, BucketSimple> statByPOID = new LinkedMap<POID, BucketSimple>(309, 1.0f){

        @Override
        protected BucketSimple create(POID pkind) {
            return new BucketSimple();
        }
    }.setMax(307);
    public long arrival = 0L;

    public static synchronized MeterService getInstance() {
        if (inst == null) {
            inst = new MeterService();
        }
        return inst;
    }

    public MeterService() {
        this.service = new BucketService();
        this.hitmap = this.conf.hitview_enabled ? new BucketHitView() : new BucketHitMap();
    }

    public void addVirtualTx(TxRecord tx) {
        this.addTxErr(tx, tx.errorLevel >= 20);
    }

    private void addTxErr(TxRecord tx, boolean err) {
        this.hitmap.add(tx, err);
        this.service.add(tx, err);
    }

    public void add(TxRecord tx) {
        boolean err;
        boolean bl = err = tx.errorLevel >= 20;
        if (this.conf.hitmap_status_mode_enabled) {
            boolean hErr = this.checkHitMapErr(tx);
            this.addTxErr(tx, hErr);
        } else {
            this.addTxErr(tx, err);
        }
        if (this.conf.tx_caller_meter_enabled && tx.mcaller_oid != 0) {
            BucketSimple c = null;
            if (tx.mcaller_pcode == Configure.PCODE) {
                c = this.statByOID.intern(tx.mcaller_oid);
                ++c.count;
                c.timesum += (long)tx.elapsed;
                if (err) {
                    ++c.error;
                }
            } else {
                c = this.statByPOID.intern(new POID(tx.mcaller_pcode, tx.mcaller_oid));
                ++c.count;
                c.timesum += (long)tx.elapsed;
                if (err) {
                    ++c.error;
                }
            }
            if (this.conf.tx_caller_meter_pkind_enabled && tx.mcaller_okind != 0) {
                c = this.statByPKIND.intern(new PKIND(tx.mcaller_pcode, tx.mcaller_okind));
                ++c.count;
                c.timesum += (long)tx.elapsed;
                if (err) {
                    ++c.error;
                }
            }
        }
    }

    private boolean checkHitMapErr(TxRecord tx) {
        if (this.conf._has_hitmap_status_mode_error_set && this.conf.hitmap_status_mode_error_set.contains(tx.status)) {
            tx.errorLevel = (byte)20;
            return true;
        }
        if (this.conf._has_hitmap_status_mode_ignore_set && this.conf.hitmap_status_mode_ignore_set.contains(tx.status)) {
            tx.errorLevel = 0;
            return false;
        }
        int status = tx.status / 100;
        if (status == 5) {
            tx.errorLevel = (byte)20;
            return true;
        }
        tx.errorLevel = 0;
        return false;
    }

    public BucketService getAndResetService() {
        BucketService b = this.service;
        this.service = new BucketService();
        return b;
    }

    public BucketHitMap getAndResetHitMap() {
        BucketHitMap b = this.hitmap;
        this.hitmap = !this.conf.hitview_enabled ? new BucketHitMap() : new BucketHitView();
        return b;
    }

    public void resetStat() {
        if (this.statByOID.size() > 0) {
            this.statByOID = new IntKeyLinkedMap<BucketSimple>(309, 1.0f){

                @Override
                protected BucketSimple create(int key) {
                    return new BucketSimple();
                }
            }.setMax(307);
        }
        if (this.statByPKIND.size() > 0) {
            this.statByPKIND = new LinkedMap<PKIND, BucketSimple>(309, 1.0f){

                @Override
                protected BucketSimple create(PKIND pkind) {
                    return new BucketSimple();
                }
            }.setMax(307);
        }
        if (this.statByPOID.size() > 0) {
            this.statByPOID = new LinkedMap<POID, BucketSimple>(309, 1.0f){

                @Override
                protected BucketSimple create(POID pkind) {
                    return new BucketSimple();
                }
            }.setMax(307);
        }
        if (this.unknown.count > 0) {
            this.unknown = new BucketSimple();
        }
    }

    public static class BucketSimple {
        public int count;
        public long timesum;
        public int error;
    }
}

