/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.meter.tx;

import java.util.concurrent.atomic.AtomicInteger;
import whatap.agent.conf.ConfApdex;
import whatap.lang.service.TxRecord;

public class BucketService {
    public final AtomicInteger count = new AtomicInteger();
    public int count_satisfied;
    public int count_tolerated;
    public long timeSum;
    public long dbcSum;
    public long sqlSum;
    public long httpcSum;
    public int error;
    public long time_sqr_sum;

    public void add(TxRecord tx, boolean err) {
        this.count.getAndIncrement();
        this.timeSum += (long)tx.elapsed;
        this.dbcSum += (long)tx.dbcTime;
        this.sqlSum += (long)tx.sqlTime;
        this.httpcSum += (long)tx.httpcTime;
        if (err) {
            ++this.error;
        } else if (tx.elapsed <= ConfApdex.apdex_time_t) {
            ++this.count_satisfied;
            tx.apdex = (byte)2;
        } else if (tx.elapsed <= ConfApdex.apdex_time_4t) {
            ++this.count_tolerated;
            tx.apdex = 1;
        }
        this.time_sqr_sum += (long)(tx.elapsed * tx.elapsed);
    }
}

