/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.meter;

import whatap.lang.H1;
import whatap.lang.ref.DOUBLE;
import whatap.lang.ref.INT;
import whatap.util.MeteringUtil;

public class MeterResource {
    private MeteringUtil<Bucket> meter = new MeteringUtil<Bucket>(){

        @Override
        protected Bucket create() {
            return new Bucket();
        }

        @Override
        protected void clear(Bucket o) {
            o.value = 0.0;
            o.count = 0;
        }
    };

    public synchronized void add(double value) {
        Bucket b = this.meter.getCurrentBucket();
        b.value += value;
        ++b.count;
    }

    public double getAvg(int period) {
        final INT count = new INT();
        final DOUBLE sum = new DOUBLE();
        this.meter.search(period, new H1<Bucket>(){

            @Override
            public void process(Bucket u) {
                sum.value += u.value;
                count.value += u.count;
            }
        });
        return count.value == 0 ? 0.0 : sum.value / (double)count.value;
    }

    public double getSum(int period) {
        final DOUBLE sum = new DOUBLE();
        this.meter.search(period, new H1<Bucket>(){

            @Override
            public void process(Bucket u) {
                sum.value += u.value;
            }
        });
        return sum.value;
    }

    static class Bucket {
        double value;
        int count;

        Bucket() {
        }
    }
}

