/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.meter;

import java.util.Comparator;
import java.util.Enumeration;
import whatap.agent.Configure;
import whatap.agent.data.DataPackSender;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.TraceContextManager;
import whatap.agent.util.ThreadNameUtil;
import whatap.lang.pack.EventPack;
import whatap.util.CompareUtil;
import whatap.util.LongLinkedSet;
import whatap.util.StringIntLinkedMap;
import whatap.util.ThreadUtil;

public class LongtimeActiveWarning
extends Thread {
    private static LongtimeActiveWarning instance = null;
    protected LongLinkedSet longTxSet = new LongLinkedSet().setMax(1000);
    Configure conf = Configure.getInstance();
    protected long last_alert = 0L;

    public static final synchronized LongtimeActiveWarning getInstance() {
        if (instance == null) {
            instance = new LongtimeActiveWarning();
            instance.setDaemon(true);
            instance.start();
            ThreadNameUtil.whatap(instance);
        }
        return instance;
    }

    public void run() {
        while (true) {
            ThreadUtil.sleep(5000L);
            try {
                if (this.conf.long_active_alert_limit <= 0L) continue;
                this.process();
            }
            catch (Throwable throwable) {
            }
        }
    }

    protected void process() {
        long now = System.currentTimeMillis();
        if (now - this.last_alert < this.conf.long_active_alert_interval) {
            return;
        }
        StringIntLinkedMap urls = new StringIntLinkedMap().setMax(100);
        Enumeration<TraceContext> en = TraceContextManager.getContextEnumeration();
        int n = 0;
        while (en.hasMoreElements()) {
            int elapsed;
            TraceContext ctx = en.nextElement();
            if (ctx != null && !this.conf.ignore_long_active.contains(ctx.service_hash) && !this.longTxSet.contains(ctx.txid) && (long)(elapsed = ctx.getElapsedTime()) >= this.conf.long_active_alert_limit) {
                this.longTxSet.put(ctx.txid);
                urls.add(ctx.service_name, 1);
            }
            ++n;
        }
        if (urls.size() > 0) {
            this.last_alert = now;
            urls.sort(new Comparator<StringIntLinkedMap.StringIntLinkedEntry>(){

                @Override
                public int compare(StringIntLinkedMap.StringIntLinkedEntry o1, StringIntLinkedMap.StringIntLinkedEntry o2) {
                    int c = CompareUtil.compareTo(o2.getValue(), o1.getValue());
                    return c != 0 ? c : CompareUtil.compareTo(o1.getKey(), o2.getKey());
                }
            });
            this.alert(urls);
        }
    }

    protected void alert(StringIntLinkedMap urls) {
        EventPack e = new EventPack();
        e.title = "LONG_ACTIVE_TX";
        e.level = (byte)20;
        e.status = 1;
        StringBuffer sb = new StringBuffer();
        String[] k = urls.keyArray();
        for (int i = 0; i < 10 && i < k.length; ++i) {
            if (i > 0) {
                sb.append("\n");
            }
            sb.append(k[i]).append("=").append(urls.get(k[i]));
        }
        e.message = sb.toString();
        DataPackSender.send(e);
    }
}

