/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.meter;

import java.io.File;
import java.util.Enumeration;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.conf.ConfThrottle;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.conf.ConfObserver;
import whatap.lang.value.ListValue;
import whatap.lang.value.MapValue;
import whatap.util.FileUtil;
import whatap.util.IntKeyLinkedMap;
import whatap.util.StringUtil;

public class BlockingDetect {
    private static BlockingDetect instance = new BlockingDetect();
    private Configure conf = Configure.getInstance();
    public IntKeyLinkedMap<ITEM> table = new IntKeyLinkedMap().setMax(ConfThrottle.blocking_detect_count);
    long last_save_time = System.currentTimeMillis();
    int entry_size = 0;
    private boolean loaded = false;

    public static final BlockingDetect getInstance() {
        return instance;
    }

    public BlockingDetect() {
        ConfObserver.add("BlockingDetect", new Runnable(){

            public void run() {
                BlockingDetect.this.table.setMax(ConfThrottle.blocking_detect_count);
                if (!ConfThrottle.blocking_detect_enabled) {
                    BlockingDetect.this.table.clear();
                }
            }
        });
    }

    public void add(int hash, String url, long endtime, int elapsed) {
        this.table.putLast(hash, new ITEM(url, endtime, elapsed));
    }

    public void save() {
        if (!ConfThrottle.blocking_detect_enabled) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now < this.last_save_time + 3600000L) {
            return;
        }
        this.last_save_time = now;
        try {
            String root = System.getProperty("whatap.home", ".");
            File blockingFile = new File(root, ConfThrottle.blocking_detect_file);
            if (this.table.size() == 0 || this.entry_size == this.table.size()) {
                return;
            }
            DataOutputX dout = new DataOutputX();
            Enumeration<IntKeyLinkedMap.IntKeyLinkedEntry<ITEM>> en = this.table.entries();
            while (en.hasMoreElements()) {
                IntKeyLinkedMap.IntKeyLinkedEntry<ITEM> ent = en.nextElement();
                ITEM m = ent.getValue();
                dout.writeBoolean(true).writeInt(ent.getKey()).writeText(m.url).writeLong(m.endtime).writeInt(m.elapsed);
            }
            dout.writeBoolean(false);
            FileUtil.save(blockingFile, dout.toByteArray());
            if (this.table.size() >= ConfThrottle.blocking_detect_count) {
                this.table.removeFirst();
            }
            this.entry_size = this.table.size();
        }
        catch (Exception e) {
            Logger.println("BlockingDetect", 10, (Throwable)e);
        }
    }

    public void load() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        try {
            String root = System.getProperty("whatap.home", ".");
            File blockingFile = new File(root, ConfThrottle.blocking_detect_file);
            if (!blockingFile.exists() || blockingFile.length() == 0L) {
                return;
            }
            byte[] b = FileUtil.readAll(blockingFile);
            if (b != null) {
                DataInputX din = new DataInputX(b);
                while (din.readBoolean()) {
                    int hash = din.readInt();
                    String url = din.readText();
                    long endtime = din.readLong();
                    int elapsed = din.readInt();
                    this.table.put(hash, new ITEM(url, endtime, elapsed));
                }
            }
        }
        catch (Exception e) {
            Logger.println("BlockingDetect", 10, (Throwable)e);
        }
    }

    public MapValue getList(String filter) {
        MapValue mv = new MapValue();
        ListValue hashLv = mv.newList("hash");
        ListValue urlLv = mv.newList("url");
        ListValue startTimeLv = mv.newList("stime");
        ListValue elapsedLv = mv.newList("elapsed");
        boolean hasFilter = StringUtil.isNotEmpty(filter);
        Enumeration<IntKeyLinkedMap.IntKeyLinkedEntry<ITEM>> en = this.table.entries();
        while (en.hasMoreElements()) {
            IntKeyLinkedMap.IntKeyLinkedEntry<ITEM> ent = en.nextElement();
            ITEM m = ent.getValue();
            if (hasFilter && m.url.indexOf(filter) < 0) continue;
            hashLv.add(ent.getKey());
            urlLv.add(m.url);
            startTimeLv.add(m.endtime);
            elapsedLv.add(m.elapsed);
        }
        return mv;
    }

    public static class ITEM {
        public String url;
        public long endtime;
        public int elapsed;

        public ITEM(String url, long endtime, int elapsed) {
            this.url = url;
            this.endtime = endtime;
            this.elapsed = elapsed;
        }
    }
}

