/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter;

import whatap.agent.Configure;
import whatap.agent.counter.meter.tx.MeterService;
import whatap.agent.counter.meter.tx.MeterServiceBackground;
import whatap.agent.counter.task.RealtimeUser;
import whatap.agent.data.DataPackSender;
import whatap.lang.pack.AbstractPack;
import whatap.util.ThreadUtil;

public class Fix5SecCollector
extends Thread {
    private static Fix5SecCollector instance;

    public static final synchronized Fix5SecCollector getInstance() {
        if (instance == null) {
            instance = new Fix5SecCollector();
            instance.setName("WhaTap-CountCollector-5Sec");
            instance.setDaemon(true);
            instance.start();
        }
        return instance;
    }

    public void run() {
        MeterService meterService = MeterService.getInstance();
        MeterServiceBackground meterServiceBackground = MeterServiceBackground.getInstance();
        Configure conf = Configure.getInstance();
        int t5sec = 5000;
        long next = 5000L + System.currentTimeMillis() / 5000L * 5000L;
        while (true) {
            long now = System.currentTimeMillis();
            while (now < next) {
                ThreadUtil.sleep(50L);
                now = System.currentTimeMillis();
            }
            now = now / 5000L * 5000L;
            next = now + 5000L;
            if (conf.realtime_interval < 5000) {
                AbstractPack hitmap = meterService.getAndResetHitMap().getPack(now);
                DataPackSender.sendHitMap(hitmap);
                hitmap = meterServiceBackground.getAndResetHitMap().getPack(now);
                DataPackSender.sendHitMap(hitmap);
                RealtimeUser.collectRealtimeUser(now);
            }
            ThreadUtil.sleep(3000L);
        }
    }
}

