/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.control.dyna;

import java.lang.instrument.ClassDefinition;
import java.util.ArrayList;
import java.util.HashSet;
import whatap.agent.Configure;
import whatap.agent.JavaAgent;
import whatap.agent.Logger;
import whatap.agent.conf.ConfHook;
import whatap.lang.value.ListValue;
import whatap.lang.value.MapValue;
import whatap.util.ClassUtil;
import whatap.util.StringEnumer;
import whatap.util.StringKeyLinkedMap;
import whatap.util.StringLinkedSet;
import whatap.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynaBCIMethod {
    public static StringLinkedSet hookedSet = new StringLinkedSet().setMax(10000);
    public static boolean isPublic = ConfHook.hook_method_access_public_enabled;
    public static boolean isPrivate = ConfHook.hook_method_access_private_enabled;
    public static boolean isProtected = ConfHook.hook_method_access_protected_enabled;
    public static boolean isNone = ConfHook.hook_method_access_none_enabled;
    public static boolean isAutoTxStart = Configure.getInstance().trace_auto_transaction_enabled;
    public static boolean isAutoTxBackstack = Configure.getInstance().trace_auto_transaction_backstack_enabled;

    public static boolean isTargetClass(String cname) {
        return hookedSet.contains(cname);
    }

    public static boolean hasTarget() {
        return hookedSet.size() > 0;
    }

    public static void update(StringKeyLinkedMap<Boolean> classMap) {
        if (hookedSet.size() == 0) {
            return;
        }
        StringEnumer en = classMap.keys();
        while (en.hasMoreElements()) {
            String cname = en.nextString();
            if (!hookedSet.contains(cname.replace('.', '/'))) continue;
            classMap.put(cname, true);
        }
    }

    public static ListValue option() {
        ListValue out = new ListValue();
        if (isPublic) {
            out.add("public");
        }
        if (isPrivate) {
            out.add("private");
        }
        if (isProtected) {
            out.add("protected");
        }
        if (isNone) {
            out.add("none");
        }
        if (isAutoTxStart) {
            out.add("auto_tx_start");
        }
        if (isAutoTxBackstack) {
            out.add("auto_tx_backstack");
        }
        return out;
    }

    public static String apply(MapValue classes, ListValue oplist) {
        DynaBCIMethod.upate(oplist);
        StringLinkedSet m2 = new StringLinkedSet();
        HashSet<String> redefSet = new HashSet<String>();
        StringEnumer en = classes.keys();
        while (en.hasMoreElements()) {
            String className = en.nextString();
            boolean doHooking = classes.getBoolean(className);
            if (doHooking) {
                m2.put(className.replace('.', '/'));
            }
            if (doHooking == hookedSet.contains(className)) continue;
            redefSet.add(className);
        }
        hookedSet = m2;
        return DynaBCIMethod.redefine(redefSet);
    }

    private static void upate(ListValue oplist) {
        isAutoTxBackstack = false;
        isAutoTxStart = false;
        isNone = false;
        isPrivate = false;
        isProtected = false;
        isPublic = false;
        for (int i = 0; i < oplist.size(); ++i) {
            String op = StringUtil.trim(oplist.getString(i));
            if ("public".equals(op)) {
                isPublic = true;
                continue;
            }
            if ("protected".equals(op)) {
                isProtected = true;
                continue;
            }
            if ("private".equals(op)) {
                isPrivate = true;
                continue;
            }
            if ("none".equals(op)) {
                isNone = true;
                continue;
            }
            if ("auto_tx_start".equals(op)) {
                isAutoTxStart = true;
                continue;
            }
            if (!"auto_tx_backstack".equals(op)) continue;
            isAutoTxBackstack = true;
        }
    }

    private static String redefine(HashSet<String> classes) {
        Class[] loadedClasses = JavaAgent.instrumentation.getAllLoadedClasses();
        ArrayList<ClassDefinition> classDefList = new ArrayList<ClassDefinition>();
        for (Class c : loadedClasses) {
            if (!classes.contains(c.getName())) continue;
            byte[] body = ClassUtil.getByteCode(c);
            if (body != null) {
                classDefList.add(new ClassDefinition(c, body));
                continue;
            }
            Logger.println("dynamic method redefine: " + c.getName() + " has no body");
        }
        if (classDefList.size() > 0) {
            ClassDefinition[] cd = classDefList.toArray(new ClassDefinition[classDefList.size()]);
            try {
                JavaAgent.instrumentation.redefineClasses(cd);
                return null;
            }
            catch (Throwable e) {
                Logger.println("dynamic method redefine:" + e);
                return "dynamic method redefine:" + e;
            }
        }
        return null;
    }
}

