/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.control;

import whatap.agent.trace.SocketTable;
import whatap.io.DataOutputX;
import whatap.lang.value.BlobValue;
import whatap.lang.value.ListValue;
import whatap.lang.value.MapValue;
import whatap.util.BitUtil;
import whatap.util.LongEnumer;
import whatap.util.LongSet;
import whatap.util.StringUtil;

public class SocketHelper {
    public static MapValue getSocketList() {
        MapValue p = new MapValue();
        ListValue keyLv = p.newList("key");
        ListValue hostLv = p.newList("host");
        ListValue portLv = p.newList("port");
        ListValue countLv = p.newList("count");
        ListValue serviceLv = p.newList("service");
        ListValue profileTxidLv = p.newList("profile_seq");
        ListValue profileTimeLv = p.newList("profile_time");
        ListValue orderLv = p.newList("order");
        ListValue stackLv = p.newList("stack");
        p.put("txid", profileTxidLv);
        p.put("update_time", profileTimeLv);
        LongEnumer en = SocketTable.socketMap.keys();
        while (en.hasMoreElements()) {
            long key = en.nextLong();
            SocketTable.Info fo = SocketTable.socketMap.get(key);
            if (fo == null) continue;
            keyLv.add(key);
            hostLv.add(new BlobValue(DataOutputX.toBytes(BitUtil.getHigh(key))));
            portLv.add(BitUtil.getLow(key));
            countLv.add(fo.count);
            serviceLv.add(fo.service);
            profileTxidLv.add(fo.txid);
            profileTimeLv.add(fo.updateTime);
            orderLv.add(fo.stackOrder);
            stackLv.add(StringUtil.trimEmpty(fo.stack));
        }
        return p;
    }

    public static void setStackOrder(ListValue list) {
        LongSet lset = SocketHelper.toSet(list);
        if (lset.size() == 0) {
            return;
        }
        LongEnumer en = SocketTable.socketMap.keys();
        while (en.hasMoreElements()) {
            long key = en.nextLong();
            SocketTable.Info fo = SocketTable.socketMap.get(key);
            if (fo == null || !lset.contains(key)) continue;
            fo.stackOrder = true;
        }
    }

    public static void unsetStackOrder(ListValue list) {
        LongSet lset = SocketHelper.toSet(list);
        if (lset.size() == 0) {
            return;
        }
        LongEnumer en = SocketTable.socketMap.keys();
        while (en.hasMoreElements()) {
            long key = en.nextLong();
            SocketTable.Info fo = SocketTable.socketMap.get(key);
            if (fo == null || !lset.contains(key)) continue;
            fo.stackOrder = false;
        }
    }

    public static void clearStack(ListValue list) {
        LongSet lset = SocketHelper.toSet(list);
        if (lset.size() == 0) {
            return;
        }
        LongEnumer en = SocketTable.socketMap.keys();
        while (en.hasMoreElements()) {
            long key = en.nextLong();
            SocketTable.Info fo = SocketTable.socketMap.get(key);
            if (fo == null || !lset.contains(key)) continue;
            fo.stack = null;
        }
    }

    private static LongSet toSet(ListValue list) {
        LongSet s = new LongSet();
        for (int i = 0; i < list.size(); ++i) {
            long v = list.getLong(i);
            if (v == 0L) continue;
            s.add(v);
        }
        return s;
    }
}

