/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.conf;

import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.conf.ConfHook;
import whatap.util.HashUtil;
import whatap.util.StringLinkedSet;
import whatap.util.StringUtil;

public class ConfWeaving {
    public static StringLinkedSet weaving_reserved = null;
    public static boolean weaving_plugin_enabled = true;
    public static boolean weaving_field_v2_enabled = false;
    public static boolean weaving_field_debug_enabled = false;
    public static boolean weaving_ignore_compile_version_enabled = true;
    public static boolean weaving_springboot2_1_enabled = false;
    public static boolean weaving_springboot2_5_enabled;
    public static boolean weaving_mongodb4_0_3_enabled;
    public static boolean weaving_springboot2_7_enabled;
    public static boolean weaving_mongodb4_4_enabled;
    public static boolean weaving_rxjava2_enabled;
    public static boolean weaving_tomcat9_enabled;
    public static boolean weaving_springboot3_0_enabled;
    public static boolean weaving_springboot3_2_enabled;
    public static boolean weaving_lettuce6_2_enabled;
    public static boolean weaving_mongodb4_8_enabled;
    public static boolean weaving_reactor_kafka1_3_enabled;
    public static boolean weaving_rxjava3_enabled;
    public static boolean weaving_tomcat10_enabled;
    public static boolean weaving_springboot_executor_enabled;
    public static boolean weaving_undertow2_3_0_enabled;
    public static boolean weaving_undertow2_3_attachKey_enabled;
    public static boolean weaving_mule4_5_enabled;
    public static boolean weaving_mule_http4_5_enabled;
    public static boolean weaving_rabbitmq_enabled;
    public static boolean weaving_spring_rabbitmq_enabled;
    public static boolean weaved;
    public static int readWeaveCount;

    public static void apply(Configure conf) {
        if (readWeaveCount-- > 0) {
            StringLinkedSet weavingSet;
            String weaving_old_conf = conf.getValue("weaving_reserved", "");
            weaving_reserved = weavingSet = ConfWeaving.getStringWeavingSet(conf, "weaving", weaving_old_conf, ",");
            if (StringUtil.isNotEmpty(conf.getValue("hook_service_reactor_patterns"))) {
                weaving_reserved.put("bci-reactor-1.0");
            }
            weaving_undertow2_3_0_enabled = conf.getBoolean("weaving_undertow2_3_0_enabled", false);
            weaving_undertow2_3_attachKey_enabled = conf.getBoolean("weaving_undertow2_3_attachKey_enabled", false);
            weaved = true;
        }
        weaved = conf.getBoolean("weaved", false);
        weaving_plugin_enabled = conf.getBoolean("weaving_plugin_enabled", true);
        weaving_field_v2_enabled = conf.getBoolean("weaving_field_v2_enabled", false);
        weaving_field_debug_enabled = conf.getBoolean("weaving_field_debug_enabled", false);
        weaving_ignore_compile_version_enabled = conf.getBoolean("weaving_ignore_compile_version_enabled", true);
    }

    public static void loadSpringBoot2_1(Configure conf, boolean on) {
        weaving_springboot2_1_enabled = conf.getBoolean("weaving_springboot2_1_enabled", on);
        weaving_tomcat9_enabled = conf.getBoolean("weaving_tomcat9_enabled", weaving_springboot2_1_enabled);
    }

    public static void loadSpringBoot2_5(Configure conf, boolean on) {
        weaving_springboot2_5_enabled = conf.getBoolean("weaving_springboot2_5_enabled", on);
        weaving_mongodb4_0_3_enabled = conf.getBoolean("weaving_mongodb4_0_3_enabled", weaving_springboot2_5_enabled);
        weaving_reactor_kafka1_3_enabled = conf.getBoolean("weaving_reactor_kafka1_3_enabled", weaving_springboot2_5_enabled);
        weaving_rxjava2_enabled = conf.getBoolean("weaving_rxjava2_enabled", weaving_springboot2_5_enabled);
        weaving_tomcat9_enabled = conf.getBoolean("weaving_tomcat9_enabled", weaving_springboot2_5_enabled);
        weaving_springboot_executor_enabled = conf.getBoolean("weaving_springboot_executor_enabled", weaving_springboot2_5_enabled);
    }

    public static void loadSpringBoot2_7(Configure conf, boolean on) {
        weaving_springboot2_7_enabled = conf.getBoolean("weaving_springboot2_7_enabled", on);
        weaving_mongodb4_4_enabled = conf.getBoolean("weaving_mongodb4_4_enabled", weaving_springboot2_7_enabled);
        weaving_reactor_kafka1_3_enabled = conf.getBoolean("weaving_reactor_kafka1_3_enabled", weaving_springboot2_7_enabled);
        weaving_rxjava2_enabled = conf.getBoolean("weaving_rxjava2_enabled", weaving_springboot2_7_enabled);
        weaving_tomcat9_enabled = conf.getBoolean("weaving_tomcat9_enabled", weaving_springboot2_7_enabled);
        weaving_springboot_executor_enabled = conf.getBoolean("weaving_springboot_executor_enabled", weaving_springboot2_7_enabled);
    }

    public static void loadSpringBoot3_0(Configure conf, boolean on) {
        weaving_springboot3_0_enabled = conf.getBoolean("weaving_springboot3_0_enabled", on);
        weaving_lettuce6_2_enabled = conf.getBoolean("weaving_lettuce6_2_enabled", weaving_springboot3_0_enabled);
        weaving_mongodb4_8_enabled = conf.getBoolean("weaving_mongodb4_8_enabled", weaving_springboot3_0_enabled);
        weaving_reactor_kafka1_3_enabled = conf.getBoolean("weaving_reactor_kafka1_3_enabled", weaving_springboot3_0_enabled);
        weaving_rxjava3_enabled = conf.getBoolean("weaving_rxjava3_enabled", weaving_springboot3_0_enabled);
        weaving_tomcat10_enabled = conf.getBoolean("weaving_tomcat10_enabled", weaving_springboot3_0_enabled);
        weaving_springboot_executor_enabled = conf.getBoolean("weaving_springboot_executor_enabled", weaving_springboot3_0_enabled);
    }

    public static void loadSpringBoot3_2(Configure conf, boolean on) {
        weaving_springboot3_2_enabled = conf.getBoolean("weaving_springboot3_2_enabled", on);
        weaving_lettuce6_2_enabled = conf.getBoolean("weaving_lettuce6_2_enabled", weaving_springboot3_2_enabled);
        weaving_reactor_kafka1_3_enabled = conf.getBoolean("weaving_reactor_kafka1_3_enabled", weaving_springboot3_2_enabled);
        weaving_rxjava3_enabled = conf.getBoolean("weaving_rxjava3_enabled", weaving_springboot3_2_enabled);
        weaving_tomcat10_enabled = conf.getBoolean("weaving_tomcat10_enabled", weaving_springboot3_2_enabled);
        weaving_springboot_executor_enabled = conf.getBoolean("weaving_springboot_executor_enabled", weaving_springboot3_2_enabled);
    }

    public static void loadMule4_5(Configure conf, boolean on) {
        weaving_mule4_5_enabled = conf.getBoolean("weaving_mule4_5_enabled", on);
        weaving_mule_http4_5_enabled = conf.getBoolean("weaving_mule_http4_5_enabled", on);
        conf.trace_ignore_url_set.put(HashUtil.hash("/mule/domains"));
        conf.trace_ignore_url_set.put(HashUtil.hash("/mule/applications"));
        ConfHook.hook_http_default_enabled = false;
        ConfHook.hook_db_native_enabled = false;
    }

    public static void loadSpringRabbitMQ(Configure conf, boolean on) {
        weaving_spring_rabbitmq_enabled = conf.getBoolean("weaving_spring_rabbitmq_enabled", on);
        weaving_rabbitmq_enabled = conf.getBoolean("weaving_rabbitmq_enabled", weaving_spring_rabbitmq_enabled);
    }

    public static StringLinkedSet getStringWeavingSet(Configure conf, String key, String defaultValue, String deli) {
        StringLinkedSet set = new StringLinkedSet();
        try {
            String[] values = StringUtil.tokenizer(conf.getValue(key, defaultValue), deli);
            if (values == null) {
                return set;
            }
            boolean hasSpringOption = false;
            for (int i = 0; i < values.length; ++i) {
                values[i] = StringUtil.trimToEmpty(values[i]);
                if (values[i].isEmpty()) continue;
                values[i] = ConfWeaving.normalizeVersion(values[i]);
                if (values[i].startsWith("spring-boot-2")) {
                    hasSpringOption = ConfWeaving.processSpringBoot2Versions(conf, set, values[i], hasSpringOption);
                    continue;
                }
                if (values[i].startsWith("spring-boot-3")) {
                    hasSpringOption = ConfWeaving.processSpringBoot3Versions(conf, set, values[i], hasSpringOption);
                    continue;
                }
                if (values[i].startsWith("spring-rabbitmq")) {
                    hasSpringOption = ConfWeaving.processSpringRabbitMQ(conf, set, values[i], hasSpringOption);
                }
                hasSpringOption = ConfWeaving.processOtherVersions(conf, set, values[i], hasSpringOption);
            }
        }
        catch (Throwable t) {
            Logger.println("Weaving", t);
        }
        return set;
    }

    private static String normalizeVersion(String version) {
        if (version.endsWith("x")) {
            if (version.equals("spring-boot-2.7.x")) {
                return "spring-boot-2.7";
            }
            if (version.equals("spring-boot-3.x")) {
                return "spring-boot-3.0";
            }
        }
        return version;
    }

    private static boolean processSpringBoot2Versions(Configure conf, StringLinkedSet set, String version, boolean hasSpringOption) {
        if ("spring-boot-2.1".equals(version)) {
            if (hasSpringOption) {
                return hasSpringOption;
            }
            ConfWeaving.loadSpringBoot2_1(conf, true);
            if (weaving_springboot2_1_enabled) {
                set.put(version);
            }
            if (weaving_tomcat9_enabled) {
                set.put("tomcat9");
            }
            return true;
        }
        if ("spring-boot-2.5".equals(version)) {
            if (hasSpringOption) {
                return hasSpringOption;
            }
            ConfWeaving.loadSpringBoot2_5(conf, true);
            ConfWeaving.addSpringBoot2_5Dependencies(set, version);
            return true;
        }
        if ("spring-boot-2.7".equals(version)) {
            if (hasSpringOption) {
                return hasSpringOption;
            }
            ConfWeaving.loadSpringBoot2_7(conf, true);
            ConfWeaving.addSpringBoot2_7Dependencies(set, version);
            return true;
        }
        return hasSpringOption;
    }

    private static boolean processSpringBoot3Versions(Configure conf, StringLinkedSet set, String version, boolean hasSpringOption) {
        if ("spring-boot-3.0".equals(version)) {
            if (hasSpringOption) {
                return hasSpringOption;
            }
            ConfWeaving.loadSpringBoot3_0(conf, true);
            ConfWeaving.addSpringBoot3_0Dependencies(set, version);
            return true;
        }
        if ("spring-boot-3.2".equals(version)) {
            if (hasSpringOption) {
                return hasSpringOption;
            }
            ConfWeaving.loadSpringBoot3_2(conf, true);
            ConfWeaving.addSpringBoot3_2Dependencies(set, version);
            return true;
        }
        return hasSpringOption;
    }

    private static boolean processOtherVersions(Configure conf, StringLinkedSet set, String version, boolean hasSpringOption) {
        if ("mule-4.5".equals(version)) {
            ConfWeaving.loadMule4_5(conf, true);
            if (weaving_mule4_5_enabled) {
                set.put(version);
            }
            if (weaving_mule_http4_5_enabled) {
                set.put("mule-http-4.5");
            }
        } else {
            set.put(version);
        }
        return hasSpringOption;
    }

    private static boolean processSpringRabbitMQ(Configure conf, StringLinkedSet set, String version, boolean hasSpringOption) {
        if ("spring-rabbitmq".equals(version)) {
            ConfWeaving.loadSpringRabbitMQ(conf, true);
            if (weaving_spring_rabbitmq_enabled) {
                set.put(version);
            }
            if (weaving_rabbitmq_enabled) {
                set.put("rabbitmq");
            }
        } else {
            set.put(version);
        }
        return hasSpringOption;
    }

    private static void addSpringBoot2_5Dependencies(StringLinkedSet set, String version) {
        if (weaving_springboot2_5_enabled) {
            set.put(version);
        }
        if (weaving_mongodb4_0_3_enabled) {
            set.put("mongodb-4.0.3");
        }
        ConfWeaving.addCommonSpringBoot2Dependencies(set);
    }

    private static void addSpringBoot2_7Dependencies(StringLinkedSet set, String version) {
        if (weaving_springboot2_7_enabled) {
            set.put(version);
        }
        if (weaving_mongodb4_4_enabled) {
            set.put("mongodb-4.4");
        }
        ConfWeaving.addCommonSpringBoot2Dependencies(set);
    }

    private static void addSpringBoot3_0Dependencies(StringLinkedSet set, String version) {
        if (weaving_springboot3_0_enabled) {
            set.put(version);
        }
        if (weaving_mongodb4_8_enabled) {
            set.put("mongodb-4.8");
        }
        if (weaving_lettuce6_2_enabled) {
            set.put("lettuce-6.2");
        }
        ConfWeaving.addCommonSpringBoot3Dependencies(set);
    }

    private static void addSpringBoot3_2Dependencies(StringLinkedSet set, String version) {
        if (weaving_springboot3_2_enabled) {
            set.put(version);
        }
        if (weaving_lettuce6_2_enabled) {
            set.put("lettuce-6.2");
        }
        ConfWeaving.addCommonSpringBoot3Dependencies(set);
    }

    private static void addCommonSpringBoot2Dependencies(StringLinkedSet set) {
        if (weaving_reactor_kafka1_3_enabled) {
            set.put("reactor-kafka-1.3");
        }
        if (weaving_rxjava2_enabled) {
            set.put("rxjava2");
        }
        if (weaving_tomcat9_enabled) {
            set.put("tomcat9");
        }
        if (weaving_springboot_executor_enabled) {
            set.put("spring-boot-executor");
        }
    }

    private static void addCommonSpringBoot3Dependencies(StringLinkedSet set) {
        if (weaving_reactor_kafka1_3_enabled) {
            set.put("reactor-kafka-1.3");
        }
        if (weaving_rxjava3_enabled) {
            set.put("rxjava3");
        }
        if (weaving_tomcat10_enabled) {
            set.put("tomcat10");
        }
        if (weaving_springboot_executor_enabled) {
            set.put("spring-boot-executor");
        }
    }

    private static StringLinkedSet checkWeavingSet(StringLinkedSet weaving_reserved) {
        try {
            if (weaving_reserved == null || weaving_reserved.isEmpty()) {
                return weaving_reserved;
            }
            String[] weavingArray = weaving_reserved.getArray();
            int sbcnt = 0;
            for (int i = 0; i < weavingArray.length; ++i) {
                if ((weavingArray[i].startsWith("spring-boot-2") || weavingArray[i].startsWith("spring-boot-3")) && sbcnt++ > 0) {
                    weaving_reserved.remove(weavingArray[i]);
                }
                if (!weavingArray[i].startsWith("webflux")) continue;
                weaving_reserved.remove(weavingArray[i]);
            }
        }
        catch (Throwable t) {
            Logger.println("Weaving", t);
        }
        return weaving_reserved;
    }

    static {
        weaving_mongodb4_0_3_enabled = weaving_springboot2_5_enabled = false;
        weaving_mongodb4_4_enabled = weaving_springboot2_7_enabled = false;
        weaving_rxjava2_enabled = weaving_springboot2_5_enabled || weaving_springboot2_7_enabled;
        weaving_tomcat9_enabled = weaving_springboot2_5_enabled || weaving_springboot2_7_enabled || weaving_springboot2_1_enabled;
        weaving_springboot3_0_enabled = false;
        weaving_springboot3_2_enabled = false;
        weaving_lettuce6_2_enabled = weaving_springboot3_0_enabled || weaving_springboot3_2_enabled;
        weaving_mongodb4_8_enabled = weaving_springboot3_0_enabled;
        weaving_reactor_kafka1_3_enabled = weaving_springboot2_5_enabled || weaving_springboot2_7_enabled || weaving_springboot3_0_enabled || weaving_springboot3_2_enabled;
        weaving_rxjava3_enabled = weaving_springboot3_0_enabled || weaving_springboot3_2_enabled;
        weaving_tomcat10_enabled = weaving_springboot3_0_enabled || weaving_springboot3_2_enabled;
        weaving_springboot_executor_enabled = weaving_springboot2_5_enabled || weaving_springboot2_7_enabled || weaving_springboot3_0_enabled || weaving_springboot3_2_enabled;
        weaving_undertow2_3_0_enabled = false;
        weaving_undertow2_3_attachKey_enabled = false;
        weaving_mule4_5_enabled = false;
        weaving_mule_http4_5_enabled = false;
        weaving_rabbitmq_enabled = false;
        weaving_spring_rabbitmq_enabled = false;
        weaved = false;
        readWeaveCount = 5;
    }
}

