/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.conf;

import whatap.agent.Configure;
import whatap.util.StringKeyLinkedMap;
import whatap.util.StringUtil;
import whatap.util.SystemUtil;

public class ConfDiskUsage {
    public static boolean diskusage_enabled = false;
    public static long diskusage_interval = 300000L;
    public static boolean diskusage_default_enabled = false;
    public static StringKeyLinkedMap<String> diskusage_path = new StringKeyLinkedMap();
    public static boolean diskusage_debug_enabled = false;

    public static void apply(Configure conf) {
        diskusage_enabled = conf.getBoolean("diskusage_enabled", false);
        diskusage_interval = conf.getLong("diskusage_interval", 300000L);
        if (diskusage_interval < 2000L) {
            diskusage_interval = 2000L;
        }
        if (SystemUtil.majorVersion < 51) {
            diskusage_enabled = false;
            return;
        }
        diskusage_debug_enabled = conf.getBoolean("diskusage_debug_enabled", false);
        diskusage_default_enabled = conf.getBoolean("diskusage_default_enabled", false);
        if (diskusage_default_enabled) {
            diskusage_path.clear();
        } else {
            int c = conf.getInt("diskusage_count", 0);
            if (c > 0) {
                StringKeyLinkedMap<String> tmp = new StringKeyLinkedMap<String>();
                for (int i = 0; i < c; ++i) {
                    String id = conf.getValue("diskusage_" + i + "_id");
                    if (StringUtil.isEmpty(id)) continue;
                    String path = conf.getValue("diskusage_" + i + "_path");
                    tmp.put(id, path);
                }
                diskusage_path = tmp;
            } else {
                diskusage_enabled = false;
            }
        }
    }
}

