/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.conf;

import java.util.ArrayList;
import java.util.List;
import whatap.agent.Configure;
import whatap.agent.conf.StackItem;
import whatap.util.ObjectUtil;
import whatap.util.StrMatch;
import whatap.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfActiveStack {
    public static boolean active_stack_enabled = true;
    public static int active_stack_count = 50;
    public static int active_stack_second = 10;
    public static int active_callstack_depth = 50;
    public static boolean auto_active_stack_count = true;
    public static boolean active_stack_zip_enabled = true;
    public static boolean active_stack_thread_name_enabled = false;
    public static boolean active_stack_perfx_enabled = false;
    public static boolean async_stack_enabled = false;
    public static int async_stack_count = 50;
    public static int async_stack_second = 10;
    public static int async_callstack_depth = 50;
    public static boolean async_stack_thread_name_enabled = true;
    public static String async_thread_match = "";
    public static StrMatch[] _async_thread_match_set = new StrMatch[0];
    public static String async_thread_parking_stack = "0:jdk.internal.misc.Unsafe.park,0:sun.misc.Unsafe.park,0:java.lang.Object.wait";
    private static List<StackItem> _async_thread_parking_ = ConfActiveStack.build(async_thread_parking_stack);

    public static void apply(Configure conf) {
        active_stack_enabled = conf.getBoolean("active_stack_enabled", true);
        active_stack_zip_enabled = conf.getBoolean("active_stack_zip_enabled", true);
        active_stack_second = conf.getInt("active_stack_second", 10);
        active_stack_count = conf.getInt("active_stack_count", 50);
        auto_active_stack_count = conf.getBoolean("auto_active_stack_count", conf.hasNotKey("active_stack_count"));
        active_stack_thread_name_enabled = conf.getBoolean("active_stack_thread_name_enabled", false);
        active_callstack_depth = conf.getInt("active_callstack_depth", conf.getInt("trace_active_callstack_depth", 50));
        active_stack_perfx_enabled = conf.getBoolean("active_stack_perfx_enabled", false);
        async_stack_enabled = conf.getBoolean("async_stack_enabled", false);
        async_stack_count = conf.getInt("async_stack_count", 50);
        async_stack_second = conf.getInt("async_stack_second", 10);
        async_callstack_depth = conf.getInt("async_callstack_depth", 50);
        async_stack_thread_name_enabled = conf.getBoolean("async_stack_thread_name_enabled", true);
        async_thread_match = conf.getValue("async_thread_match", "");
        _async_thread_match_set = conf.getStrMatchArray("async_thread_match", "", ",");
        String value = conf.getValue("async_thread_parking_stack", "0:jdk.internal.misc.Unsafe.park,0:sun.misc.Unsafe.park,0:java.lang.Object.wait");
        if (!ObjectUtil.equals(value, async_thread_parking_stack)) {
            async_thread_parking_stack = value;
            _async_thread_parking_ = ConfActiveStack.build(value);
        }
    }

    private static ArrayList<StackItem> build(String v) {
        ArrayList<StackItem> set = new ArrayList<StackItem>();
        try {
            if (v != null) {
                String[] words;
                for (String line : words = StringUtil.tokenizer(v, ",")) {
                    String[] tokens = StringUtil.divKeyValue(line = StringUtil.trimToEmpty(line), ":");
                    if (tokens.length != 2) continue;
                    try {
                        StackItem m = new StackItem();
                        m.idx = Integer.parseInt(tokens[0]);
                        String classMethod = tokens[1];
                        int p = classMethod.lastIndexOf(".");
                        if (p <= 0) continue;
                        m.class1 = classMethod.substring(0, p);
                        m.method = classMethod.substring(p + 1);
                        set.add(m);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return set;
    }

    public static boolean isEmptyOrParking(StackTraceElement[] se) {
        if (se == null || se.length == 0) {
            return true;
        }
        for (StackItem m : _async_thread_parking_) {
            if (!m.isOk(se)) continue;
            return true;
        }
        return false;
    }
}

