/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.boot;

import java.io.File;
import whatap.agent.Configure;
import whatap.agent.JavaAgent;
import whatap.agent.Logger;
import whatap.agent.data.DataPackSender;
import whatap.agent.util.AsyncRunner;
import whatap.lang.pack.ParamPack;
import whatap.util.JarUtil;
import whatap.util.StringEnumer;
import whatap.util.StringKeyLinkedMap;
import whatap.util.StringUtil;

public class ComponentsVersions {
    private static StringKeyLinkedMap<String> versionTable = new StringKeyLinkedMap().setMax(1000);
    private static Configure conf = Configure.getInstance();
    private static long stime = System.currentTimeMillis();
    private static int reset = 0;

    static void search(Class c) {
        try {
            if (ComponentsVersions.ignore(c.getName())) {
                return;
            }
            String jarName = JarUtil.getSpringJarName(c);
            if (jarName == null || versionTable.containsKey(jarName)) {
                return;
            }
            String ver = JarUtil.getJarFileNameVersion(jarName);
            versionTable.put(jarName, StringUtil.trimEmpty(ver));
        }
        finally {
            return;
        }
    }

    public static synchronized void send() {
        if (versionTable.size() == 0) {
            return;
        }
        ParamPack param = new ParamPack();
        StringEnumer en = versionTable.keys();
        while (en.hasMoreElements()) {
            String name = en.nextString();
            String version = versionTable.get(name);
            String jarname = new File(name).getName();
            param.put(jarname, version);
        }
        DataPackSender.sendCompVer(param);
    }

    public static String getJarVersion(String path) {
        return versionTable.get(path);
    }

    public static void search() {
        if (!ComponentsVersions.conf.trace_component_enabled) {
            return;
        }
        long now = System.currentTimeMillis();
        if (reset == ComponentsVersions.conf.trace_component_reset && now - stime < 600000L) {
            return;
        }
        stime = Long.MAX_VALUE;
        reset = ComponentsVersions.conf.trace_component_reset;
        if (JavaAgent.instrumentation == null) {
            return;
        }
        AsyncRunner.getInstance().add(new Runnable(){

            public void run() {
                int err = 0;
                Class[] classes = JavaAgent.instrumentation.getAllLoadedClasses();
                for (int i = 0; i < classes.length; ++i) {
                    try {
                        if (classes[i].getClassLoader() == null) continue;
                        ComponentsVersions.search(classes[i]);
                        continue;
                    }
                    catch (Throwable t) {
                        if (err++ >= 5) continue;
                        Logger.println(t.getMessage());
                    }
                }
                ComponentsVersions.send();
            }
        });
    }

    private static boolean ignore(String className) {
        if (className.startsWith("whatap")) {
            return true;
        }
        if (className.startsWith("sun")) {
            return true;
        }
        if (className.startsWith("com.sun")) {
            return true;
        }
        if (className.startsWith("org.hyperic")) {
            return true;
        }
        return className.startsWith("jdk");
    }
}

