/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm.weaving;

import whatap.agent.asm.weaving.WeaveUtil;
import whatap.org.objectweb.asm.Type;
import whatap.org.objectweb.asm.tree.AbstractInsnNode;
import whatap.org.objectweb.asm.tree.InsnList;
import whatap.org.objectweb.asm.tree.InsnNode;
import whatap.org.objectweb.asm.tree.LabelNode;
import whatap.org.objectweb.asm.tree.MethodInsnNode;
import whatap.org.objectweb.asm.tree.MethodNode;
import whatap.org.objectweb.asm.tree.TypeInsnNode;
import whatap.org.objectweb.asm.tree.VarInsnNode;

public class OriginMethodCall {
    private final String weaveClass;
    private final MethodNode weaveMethod;
    private MethodNode result;
    private boolean okMerge;
    private LabelNode startCallOrigin = null;
    private LabelNode endCallOrigin = null;

    public OriginMethodCall(String weaveClass, MethodNode weaveMethod) {
        this.weaveClass = weaveClass;
        this.weaveMethod = weaveMethod;
    }

    public OriginMethodCall replace(String methodPrefix) {
        MethodNode result = WeaveUtil.copy(this.weaveMethod);
        MethodInsnNode originCallInsn = OriginMethodCall.findOriginMethodCall(result.instructions);
        if (originCallInsn == null) {
            this.okMerge = false;
            this.result = result;
            return this;
        }
        this.startCallOrigin = WeaveUtil.makeLabelNode();
        this.endCallOrigin = WeaveUtil.makeLabelNode();
        result.instructions.insertBefore((AbstractInsnNode)originCallInsn, this.startCallOrigin);
        boolean isStatic = (this.weaveMethod.access & 8) != 0;
        int index = 0;
        if (!isStatic) {
            result.instructions.insertBefore((AbstractInsnNode)originCallInsn, new VarInsnNode(25, index++));
        }
        for (Type argType : Type.getArgumentTypes(result.desc)) {
            result.instructions.insertBefore((AbstractInsnNode)originCallInsn, new VarInsnNode(argType.getOpcode(21), index));
            index += argType.getSize();
        }
        int invokeOpcode = isStatic ? 184 : 182;
        result.instructions.insertBefore((AbstractInsnNode)originCallInsn, new MethodInsnNode(invokeOpcode, this.weaveClass, methodPrefix + result.name, result.desc, false));
        Type returnType = Type.getReturnType(this.weaveMethod.desc);
        AbstractInsnNode nextInsn = originCallInsn.getNext();
        switch (returnType.getSort()) {
            case 0: {
                if (nextInsn.getOpcode() != 87) {
                    throw new RuntimeException("invalid op code for Void return op=" + nextInsn.getOpcode());
                }
                result.instructions.remove(nextInsn);
                result.instructions.insert((AbstractInsnNode)originCallInsn, this.endCallOrigin);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                TypeInsnNode castInsn;
                if (nextInsn.getOpcode() == 87) {
                    if (returnType.getSize() == 2) {
                        result.instructions.remove(nextInsn);
                        result.instructions.insert((AbstractInsnNode)originCallInsn, new InsnNode(88));
                    }
                    result.instructions.insert((AbstractInsnNode)originCallInsn, this.endCallOrigin);
                    break;
                }
                if (nextInsn.getOpcode() == 192) {
                    castInsn = (TypeInsnNode)nextInsn;
                    result.instructions.remove(castInsn);
                    AbstractInsnNode thirdInsn = originCallInsn.getNext();
                    if (thirdInsn.getOpcode() == 182) {
                        MethodInsnNode invokeInsn = (MethodInsnNode)thirdInsn;
                        result.instructions.remove(invokeInsn);
                    }
                }
                result.instructions.insert((AbstractInsnNode)originCallInsn, this.endCallOrigin);
                break;
            }
            case 9: 
            case 10: {
                TypeInsnNode castInsn;
                if (nextInsn.getOpcode() == 192) {
                    result.instructions.insert(nextInsn, this.endCallOrigin);
                    castInsn = (TypeInsnNode)nextInsn;
                    if (!Type.getObjectType(castInsn.desc).equals(returnType)) break;
                    result.instructions.remove(castInsn);
                    break;
                }
                result.instructions.insert((AbstractInsnNode)originCallInsn, this.endCallOrigin);
                break;
            }
            default: {
                throw new RuntimeException("invalid return type=" + returnType.getSort());
            }
        }
        result.instructions.remove(originCallInsn);
        this.okMerge = true;
        this.result = result;
        return this;
    }

    public static MethodInsnNode findOriginMethodCall(InsnList instructions) {
        int size = instructions.size();
        for (int i = 0; i < size; ++i) {
            AbstractInsnNode insn = instructions.get(i);
            if (insn.getType() != 5) continue;
            MethodInsnNode methodInsn = (MethodInsnNode)insn;
            if (!WeaveUtil.isOriginMethodInvocation(methodInsn.owner, methodInsn.name, methodInsn.desc)) continue;
            return methodInsn;
        }
        return null;
    }

    public boolean isMerged() {
        return this.okMerge;
    }

    public MethodNode getMethodNode() {
        return this.result;
    }
}

