/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm.weaving;

import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.JarFile;
import whatap.agent.Logger;
import whatap.util.AnsiPrint;
import whatap.util.JarUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddNewClass {
    static final Method defineClassMethod;

    public static void addToSystemClassLoader(Instrumentation instrumentation, Map<String, byte[]> classBytesMap) throws IOException {
        instrumentation.appendToBootstrapClassLoaderSearch(new JarFile(JarUtil.createJarFile("bootclass", classBytesMap)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToClassLoader(ClassLoader classloader, Map<String, byte[]> classBytesMap) throws IOException {
        ClassLoader classLoader = classloader;
        synchronized (classLoader) {
            AddNewClass.addClasses(classloader, classBytesMap);
        }
    }

    private static void addClasses(ClassLoader classloader, Map<String, byte[]> classBytesMap) throws IOException {
        ProtectionDomain protectionDomain = AddNewClass.class.getProtectionDomain();
        int loaded = 0;
        boolean continueLoading = true;
        HashMap<String, byte[]> loadedClasses = new HashMap<String, byte[]>();
        HashSet<String> failToLoad = new HashSet<String>(classBytesMap.keySet());
        while (continueLoading && failToLoad.size() > 0) {
            continueLoading = false;
            for (String classname : failToLoad) {
                byte[] classBytes = classBytesMap.get(classname);
                if (null == classBytes) continue;
                try {
                    defineClassMethod.invoke((Object)classloader, classname.replace('/', '.'), classBytes, 0, classBytes.length, protectionDomain);
                    ++loaded;
                    continueLoading = true;
                    loadedClasses.put(classname, classBytes);
                }
                catch (Exception e) {
                    if (e.getCause() instanceof LinkageError) {
                        String errorMessage = e.getCause().getMessage();
                        if (errorMessage == null || !errorMessage.contains("duplicate class definition")) continue;
                        continueLoading = true;
                        loadedClasses.put(classname, classBytes);
                        continue;
                    }
                    throw new IOException(e);
                }
            }
            failToLoad.removeAll(loadedClasses.keySet());
        }
        Logger.println("Weaving", AnsiPrint.green("additional load  #" + loaded + "  by " + AddNewClass.getName(classloader)));
        if (failToLoad.size() > 0) {
            Logger.println("Weaving", AnsiPrint.red("fail additional load " + failToLoad + " loader=" + AddNewClass.getName(classloader)));
        }
    }

    private static String getName(ClassLoader loader) {
        if (loader == null) {
            return "BootClassLoader";
        }
        return loader.getClass().getName() + "(" + System.identityHashCode(loader) + ")";
    }

    static {
        try {
            defineClassMethod = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
            defineClassMethod.setAccessible(true);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }
}

