/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm.etc;

import whatap.agent.asm.IASM;
import whatap.agent.trace.CompletableFutureTrace;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Opcodes;
import whatap.org.objectweb.asm.commons.LocalVariablesSorter;
import whatap.util.StringLinkedSet;
import whatap.util.StringUtil;

class AsyncWrapSubTxMV
extends LocalVariablesSorter
implements Opcodes {
    private static final String CLASS = CompletableFutureTrace.class.getName().replace('.', '/');
    private static final String WRAP_METHOD = "trace";
    private String WRAP_SIGNATURE;
    private StringLinkedSet point;
    private String checkSig;

    public AsyncWrapSubTxMV(int access, String desc, MethodVisitor mv, String asyncClass, StringLinkedSet point) {
        super(IASM.API, access, desc, mv);
        this.WRAP_SIGNATURE = "(" + asyncClass + ")" + asyncClass;
        this.point = point;
        this.checkSig = asyncClass + ")";
    }

    public void visitMethodInsn(int opcode, String owner, String methodName, String descriptor, boolean isInterface) {
        String ownerSimpleName;
        if ((opcode == 184 || opcode == 182) && descriptor.indexOf(this.checkSig) >= 0 && this.point.contains((ownerSimpleName = StringUtil.cutLastString(owner, '/')) + "." + methodName)) {
            this.mv.visitMethodInsn(184, CLASS, WRAP_METHOD, this.WRAP_SIGNATURE, false);
        }
        this.mv.visitMethodInsn(opcode, owner, methodName, descriptor, isInterface);
    }
}

