/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm.etc;

import whatap.agent.Logger;
import whatap.agent.asm.IASM;
import whatap.agent.asm.etc.AsyncWrapSubTxMV;
import whatap.agent.asm.util.AsmUtil;
import whatap.agent.asm.util.HookingSet;
import whatap.agent.conf.ConfHook;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Opcodes;
import whatap.util.StringLinkedSet;
import whatap.util.StringUtil;

class AsyncWrapSubTxCV
extends ClassVisitor
implements Opcodes {
    public String className;
    private HookingSet mset;
    private String asyncClass;
    private StringLinkedSet point;

    public AsyncWrapSubTxCV(ClassVisitor cv, String asyncClass, HookingSet mset, String className, StringLinkedSet point) {
        super(IASM.API, cv);
        this.asyncClass = asyncClass;
        this.mset = mset;
        this.className = StringUtil.cutLastString(className.replace('/', '.'), '.');
        this.point = point;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (mv == null || !this.mset.isA(name, desc)) {
            return mv;
        }
        if (AsmUtil.isSpecial(name)) {
            return mv;
        }
        Logger.println("BCI", "wrap-runnable " + this.className + "#" + name + " point: " + ConfHook.hook_async_runnable_point);
        return new AsyncWrapSubTxMV(access, desc, mv, this.asyncClass, this.point);
    }
}

