/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import java.util.HashMap;
import java.util.List;
import whatap.agent.ClassDesc;
import whatap.agent.asm.IASM;
import whatap.agent.asm.ReservedSet;
import whatap.agent.asm.ServiceBackgroundCV;
import whatap.agent.asm.util.HookingSet;
import whatap.agent.asm.weaving.WeavingHookSet;
import whatap.agent.conf.ConfHook;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.Opcodes;

public class ServiceBackgroundASM
extends IASM
implements Opcodes {
    private List<HookingSet> target = HookingSet.getHookingMethodSet(ConfHook.hook_service_background_patterns);
    private HashMap<String, HookingSet> supers = HookingSet.getHookingClassMethodSet(ConfHook.hook_service_background_supers);
    private HashMap<String, HookingSet> interfaces = HookingSet.getHookingClassMethodSet(ConfHook.hook_service_background_interfaces);

    public void reserved(ReservedSet classSet) {
        classSet.addClass(this.target);
    }

    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!ConfHook.hook_service_background_enabled) {
            return cv;
        }
        HookingSet hset = WeavingHookSet.service.get(className);
        if (hset != null) {
            return new ServiceBackgroundCV(cv, hset, className);
        }
        for (int i = 0; i < this.target.size(); ++i) {
            HookingSet mset = this.target.get(i);
            if (!mset.classMatch.include(className)) continue;
            return new ServiceBackgroundCV(cv, mset, className);
        }
        HookingSet mset = this.supers.get(classDesc.superName);
        if (mset != null) {
            return new ServiceBackgroundCV(cv, mset, className);
        }
        if (this.interfaces.size() > 0 && classDesc.interfaces != null) {
            for (int i = 0; i < classDesc.interfaces.length; ++i) {
                mset = this.interfaces.get(classDesc.interfaces[i]);
                if (mset == null) continue;
                return new ServiceBackgroundCV(cv, mset, className);
            }
        }
        return cv;
    }
}

