/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import java.util.HashMap;
import java.util.List;
import whatap.agent.ClassDesc;
import whatap.agent.asm.IASM;
import whatap.agent.asm.MethodCV;
import whatap.agent.asm.ReservedSet;
import whatap.agent.asm.util.HookingSet;
import whatap.agent.asm.util.HookingSetUtil;
import whatap.agent.asm.weaving.WeavingHookSet;
import whatap.agent.conf.ConfHook;
import whatap.agent.control.profile.DynaHook;
import whatap.agent.control.profile.DynaMethodProfile;
import whatap.agent.control.profile.DynaProfileControl;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.Opcodes;
import whatap.util.StrMatch;

public class MethodASM
extends IASM
implements Opcodes {
    private List<HookingSet> target = HookingSet.getHookingMethodSet(ConfHook.hook_method_patterns);
    private HashMap<String, HookingSet> supers = HookingSet.getHookingClassMethodSet(ConfHook.hook_method_supers);
    private HashMap<String, HookingSet> interfaces = HookingSet.getHookingClassMethodSet(ConfHook.hook_method_interfaces);
    private boolean hasConf;
    private List<StrMatch> ignoreClassPattern = HookingSetUtil.getMatchList(ConfHook.hook_method_ignore_class_patterns);
    private DynaMethodProfile dynaProfile = DynaProfileControl.methodProfile;

    public void reserved(ReservedSet classSet) {
        classSet.addClass(this.target);
    }

    public MethodASM() {
        this.hasConf = this.target.size() > 0 || this.supers.size() > 0 || this.interfaces.size() > 0;
    }

    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        DynaHook dynaHook;
        HookingSet hset;
        if (!ConfHook.hook_methods_enabled) {
            return cv;
        }
        if (!this.hasConf && WeavingHookSet.method.size() == 0) {
            return cv;
        }
        if (ConfHook.isIgnoreMethodClass(className)) {
            return cv;
        }
        if (this.ignoreClassPattern.size() > 0) {
            for (int i = 0; i < this.ignoreClassPattern.size(); ++i) {
                StrMatch sm = this.ignoreClassPattern.get(i);
                if (!sm.include(className)) continue;
                return cv;
            }
        }
        if ((hset = WeavingHookSet.method.get(className)) != null) {
            return new MethodCV(cv, hset, className);
        }
        for (int i = 0; i < this.target.size(); ++i) {
            HookingSet mset = this.target.get(i);
            if (!mset.classMatch.include(className)) continue;
            return new MethodCV(cv, mset, className);
        }
        HookingSet mset = this.supers.get(classDesc.superName);
        if (mset != null) {
            return new MethodCV(cv, mset, className);
        }
        if (this.interfaces.size() > 0 && classDesc.interfaces != null) {
            for (int i = 0; i < classDesc.interfaces.length; ++i) {
                mset = this.interfaces.get(classDesc.interfaces[i]);
                if (mset == null) continue;
                return new MethodCV(cv, mset, className);
            }
        }
        if ((dynaHook = this.dynaProfile.getDyna(className)) != null) {
            switch (dynaHook.stat) {
                case 1: {
                    dynaHook.stat = (byte)3;
                    if (dynaHook.method == null || dynaHook.method.size() == 0) {
                        return new MethodCV(cv, new HookingSet().setAll(), className);
                    }
                    return new MethodCV(cv, new HookingSet().addList(dynaHook.method), className);
                }
                case 2: {
                    dynaHook.stat = 0;
                    return new MethodCV(cv, HookingSet.empty, className);
                }
            }
        }
        return cv;
    }
}

