/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import whatap.agent.asm.IASM;
import whatap.agent.asm.MStatMV;
import whatap.agent.asm.util.AsmUtil;
import whatap.agent.asm.util.HookingSet;
import whatap.agent.trace.MethodStat;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Opcodes;
import whatap.util.HashUtil;

class MStatCV
extends ClassVisitor
implements Opcodes {
    public String className;
    private HookingSet mset;
    private String idClass;

    public MStatCV(ClassVisitor cv, HookingSet mset, String className, String idClass) {
        super(IASM.API, cv);
        this.mset = mset;
        this.className = className;
        this.idClass = idClass;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (mv == null || !this.mset.isA(name, desc)) {
            return mv;
        }
        if (AsmUtil.isSpecial(name)) {
            return mv;
        }
        int idClassHash = HashUtil.hash(this.idClass);
        int name_index = MethodStat.add(idClassHash, this.idClass);
        if (name_index < 0) {
            return mv;
        }
        return new MStatMV(access, desc, mv, name_index);
    }
}

