/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import java.util.HashMap;
import java.util.List;
import whatap.agent.ClassDesc;
import whatap.agent.asm.DbcCloseCV;
import whatap.agent.asm.IASM;
import whatap.agent.asm.ReservedSet;
import whatap.agent.asm.util.AsmUtil;
import whatap.agent.asm.util.HookingSet;
import whatap.agent.conf.ConfHook;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.Opcodes;

public class JDBCConnectionCloseASM
extends IASM
implements Opcodes {
    private List<HookingSet> target = HookingSet.getHookingMethodSet(ConfHook.hook_connection_close_patterns);
    private HashMap<String, HookingSet> reserved = new HashMap();

    public JDBCConnectionCloseASM() {
        if (!ConfHook.hook_connection_close_default_enabled) {
            return;
        }
        AsmUtil.add(this.reserved, "org.apache.commons.dbcp.PoolingDataSource$PoolGuardConnectionWrapper", "close()V");
        AsmUtil.add(this.reserved, "org.apache.tomcat.dbcp.dbcp.PoolingDataSource$PoolGuardConnectionWrapper", "close()V");
        AsmUtil.add(this.reserved, "org.apache.tomcat.dbcp.dbcp2.PoolingDataSource$PoolGuardConnectionWrapper", "close()V");
        AsmUtil.add(this.reserved, "org.apache.commons.dbcp2.PoolingDataSource$PoolGuardConnectionWrapper", "close()V");
        AsmUtil.add(this.reserved, "com.zaxxer.hikari.pool.ProxyConnection", "close()V");
    }

    public void reserved(ReservedSet classSet) {
        classSet.addClass(this.reserved.keySet());
    }

    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!ConfHook.hook_dbopen_enabled) {
            return cv;
        }
        for (int i = 0; i < this.target.size(); ++i) {
            HookingSet mset = this.target.get(i);
            if (!mset.classMatch.include(className)) continue;
            return new DbcCloseCV(cv, mset, className);
        }
        HookingSet mset = this.reserved.get(className);
        if (mset != null) {
            return new DbcCloseCV(cv, mset, className);
        }
        return cv;
    }
}

