/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import whatap.agent.ClassDesc;
import whatap.agent.asm.HttpcExtCV;
import whatap.agent.asm.IASM;
import whatap.agent.asm.ReservedSet;
import whatap.agent.asm.util.AsmUtil;
import whatap.agent.asm.util.HookingSet;
import whatap.agent.conf.ConfHook;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.Opcodes;

public class HttpcASM
extends IASM
implements Opcodes {
    private List<HookingSet> target = HookingSet.getHookingMethodSet(ConfHook.hook_httpc_patterns);
    private Map<String, HookingSet> reserved = new HashMap<String, HookingSet>();
    private HashMap<String, HookingSet> supers = HookingSet.getHookingClassMethodSet(ConfHook.hook_httpc_supers);
    private HashMap<String, HookingSet> interfaces = HookingSet.getHookingClassMethodSet(ConfHook.hook_httpc_interfaces);

    public HttpcASM() {
        if (ConfHook.hook_httpc_sap3_enabled) {
            AsmUtil.add(this.interfaces, "com/sap/conn/jco/JCoFunction", "execute");
        }
        AsmUtil.add(this.reserved, "tmax/webt/WebtRemoteService", "tpcall(Ljava/lang/String;Ltmax/webt/WebtBuffer;Ltmax/webt/WebtAttribute;)Ltmax/webt/WebtBuffer;");
        AsmUtil.add(this.reserved, "weblogic/wtc/gwt/TuxedoConnection", "tpcall(Ljava/lang/String;Lweblogic/wtc/jatmi/TypedBuffer;I)Lweblogic/wtc/jatmi/Reply;");
        AsmUtil.add(this.reserved, "bea/jolt/pool/SessionPool", "call(Ljava/lang/String;Lbea/jolt/pool/DataSet;Lbea/jolt/pool/Transaction;)Lbea/jolt/pool/Result;");
        AsmUtil.add(this.reserved, "httpc/FakeHttpc", "call(Ljava/lang/String;)Ljava/lang/String;");
        AsmUtil.add(this.reserved, "org/apache/commons/httpclient/HttpClient", "executeMethod(Lorg/apache/commons/httpclient/HostConfiguration;Lorg/apache/commons/httpclient/HttpMethod;Lorg/apache/commons/httpclient/HttpState;)I");
        AsmUtil.add(this.reserved, "org.apache.hc.client5.http.impl.classic.InternalHttpClient", "doExecute");
        AsmUtil.add(this.reserved, "org.apache.hc.client5.http.impl.classic.MinimalHttpClient", "doExecute");
        AsmUtil.add(this.reserved, "org/apache/http/impl/client/InternalHttpClient", "doExecute");
        AsmUtil.add(this.reserved, "org/apache/http/impl/client/MinimalHttpClient", "doExecute");
        AsmUtil.add(this.reserved, "org/apache/http/impl/client/AbstractHttpClient", "doExecute");
        AsmUtil.add(this.reserved, "org/apache/http/impl/client/AbstractHttpClient", "execute(Lorg/apache/http/HttpHost;Lorg/apache/http/HttpRequest;Lorg/apache/http/protocol/HttpContext;)Lorg/apache/http/HttpResponse;");
        AsmUtil.add(this.reserved, "org/springframework/web/client/AbstractClientHttpRequest", "execute()Lorg/springframework/http/client/ClientHttpResponse;");
        AsmUtil.add(this.reserved, "org/springframework/web/client/Netty4ClientHttpRequest", "execute()Lorg/springframework/http/client/ClientHttpResponse;");
        AsmUtil.add(this.reserved, "org/springframework/web/client/OkHttpClientHttpRequest", "execute()Lorg/springframework/http/client/ClientHttpResponse;");
        AsmUtil.add(this.reserved, "play/libs/WS$WSRequestHolder", "execute(Lplay/libs/WS$WSRequest;)Lplay/libs/F$Promise;");
        AsmUtil.add(this.reserved, "io/reactivex/netty/protocol/http/client/HttpClientImpl", "submit");
        AsmUtil.add(this.reserved, "org/apache/soap/rpc/Call", "invoke(Ljava/net/URL;Ljava/lang/String;Ljava/util/Hashtable;)Lorg/apache/soap/rpc/Response;");
        if (ConfHook.HttpURLConnection) {
            AsmUtil.add(this.reserved, "sun/net/www/protocol/http/HttpURLConnection", "getInputStream()Ljava/io/InputStream;");
            AsmUtil.add(this.reserved, "sun/net/www/protocol/http/HttpURLConnection", "getOutputStream()Ljava/io/OutputStream;");
            AsmUtil.add(this.reserved, "sun/net/www/protocol/http/HttpURLConnection", "connect()V");
        }
        if (ConfHook.HttpURLConnection_weblogic) {
            AsmUtil.add(this.reserved, "weblogic/net/http/HttpURLConnection", "getInputStream()Ljava/io/InputStream;");
            AsmUtil.add(this.reserved, "weblogic/net/http/HttpURLConnection", "getOutputStream()Ljava/io/OutputStream;");
            AsmUtil.add(this.reserved, "weblogic/net/http/HttpURLConnection", "connect()V");
        }
    }

    public void reserved(ReservedSet classSet) {
        classSet.addClass(this.reserved.keySet());
    }

    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        int i;
        if (!ConfHook.hook_httpc_enabled) {
            return cv;
        }
        HookingSet mset = this.reserved.get(className);
        if (mset != null) {
            return new HttpcExtCV(cv, mset, className, className);
        }
        for (i = 0; i < this.target.size(); ++i) {
            mset = this.target.get(i);
            if (!mset.classMatch.include(className)) continue;
            return new HttpcExtCV(cv, mset, className, className);
        }
        mset = this.supers.get(classDesc.superName);
        if (mset != null) {
            return new HttpcExtCV(cv, mset, className, classDesc.superName);
        }
        if (this.interfaces.size() > 0 && classDesc.interfaces != null) {
            for (i = 0; i < classDesc.interfaces.length; ++i) {
                mset = this.interfaces.get(classDesc.interfaces[i]);
                if (mset == null) continue;
                return new HttpcExtCV(cv, mset, className, classDesc.interfaces[i]);
            }
        }
        return cv;
    }
}

