/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import whatap.agent.Logger;
import whatap.agent.asm.HttpValveJakartaMV;
import whatap.agent.asm.HttpValveJavaxMV;
import whatap.agent.asm.IASM;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Opcodes;

class HttpValveCV
extends ClassVisitor
implements Opcodes {
    private static String TARGET_INVOKE = "invoke";
    private static String TARGET_SIGNATURE_HOSTVALVE = "(Lorg/apache/catalina/connector/Request;Lorg/apache/catalina/connector/Response;";
    private String className;

    public HttpValveCV(ClassVisitor cv, String className) {
        super(IASM.API, cv);
        this.className = className;
    }

    private boolean hasJakartaServletException(String[] exceptions) {
        if (exceptions != null) {
            for (int i = 0; i < exceptions.length; ++i) {
                if (!exceptions[i].startsWith("jakarta")) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasJavaxServletException(String[] exceptions) {
        if (exceptions != null) {
            for (int i = 0; i < exceptions.length; ++i) {
                if (!exceptions[i].startsWith("javax")) continue;
                return true;
            }
        }
        return false;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (mv == null) {
            return mv;
        }
        if (desc.startsWith(TARGET_SIGNATURE_HOSTVALVE) && TARGET_INVOKE.equals(name)) {
            Logger.println("BCI", "http " + this.className);
            if (this.hasJavaxServletException(exceptions)) {
                return new HttpValveJavaxMV(access, desc, mv);
            }
            if (this.hasJakartaServletException(exceptions)) {
                return new HttpValveJakartaMV(access, desc, mv);
            }
        }
        return mv;
    }
}

