/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import java.util.HashSet;
import whatap.agent.ClassDesc;
import whatap.agent.asm.HttpValveCV;
import whatap.agent.asm.IASM;
import whatap.agent.asm.ReservedSet;
import whatap.agent.asm.util.HookingSet;
import whatap.agent.conf.ConfHook;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.Opcodes;

public class HttpValveASM
extends IASM
implements Opcodes {
    public HashSet<String> valves = HookingSet.getHookingClassSet(ConfHook.hook_valve_classes);

    public HttpValveASM() {
        if (ConfHook.hook_valve_default_enabled) {
            this.valves.add("org/apache/catalina/core/StandardHostValve");
        }
    }

    public void reserved(ReservedSet classSet) {
        classSet.addClass(this.valves);
    }

    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!ConfHook.hook_valve_http_enabled) {
            return cv;
        }
        if (this.valves.contains(className)) {
            return new HttpValveCV(cv, className);
        }
        if (this.valves.contains(classDesc.superName)) {
            return new HttpValveCV(cv, className);
        }
        for (int i = 0; i < classDesc.interfaces.length; ++i) {
            if (!this.valves.contains(classDesc.interfaces[i])) continue;
            return new HttpValveCV(cv, className);
        }
        return cv;
    }
}

