/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import whatap.agent.Logger;
import whatap.agent.asm.HttpServiceMV;
import whatap.agent.asm.IASM;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Opcodes;

class HttpServiceCV
extends ClassVisitor
implements Opcodes {
    private static String TARGET_SERVICE = "service";
    private static String TARGET_DOFILTER = "doFilter";
    private static String TARGET_SIGNATURE = "(Ljavax/servlet/ServletRequest;Ljavax/servlet/ServletResponse;";
    private static String JAKARTA_SERVLET_EXCEPTION = "jakarta/servlet/ServletException";
    private String className;

    public HttpServiceCV(ClassVisitor cv, String className) {
        super(IASM.API, cv);
        this.className = className;
    }

    private boolean hasJakartaServletException(String[] exceptions) {
        if (exceptions != null) {
            for (int i = 0; i < exceptions.length; ++i) {
                if (!JAKARTA_SERVLET_EXCEPTION.equals(exceptions[i])) continue;
                return true;
            }
        }
        return false;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (mv == null) {
            return mv;
        }
        if (this.hasJakartaServletException(exceptions)) {
            Logger.println("BCI", "Skip javax " + this.className + "." + name + " due to jakarta.servlet.ServletException");
            return mv;
        }
        if (desc.startsWith(TARGET_SIGNATURE)) {
            if (TARGET_SERVICE.equals(name)) {
                Logger.println("BCI", "javax http " + this.className);
                return new HttpServiceMV(access, desc, mv, true);
            }
            if (TARGET_DOFILTER.equals(name)) {
                Logger.println("BCI", "javax http-filter " + this.className);
                return new HttpServiceMV(access, desc, mv, false);
            }
        }
        return mv;
    }
}

