/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import java.util.HashSet;
import whatap.agent.ClassDesc;
import whatap.agent.asm.HttpServiceCV;
import whatap.agent.asm.IASM;
import whatap.agent.asm.ReservedSet;
import whatap.agent.asm.util.HookingSet;
import whatap.agent.asm.weaving.WeavingHookSet;
import whatap.agent.conf.ConfHook;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.Opcodes;

public class HttpServiceASM
extends IASM
implements Opcodes {
    public HashSet<String> servlets = HookingSet.getHookingClassSet(ConfHook.hook_httpservlet_classes);
    public HashSet<String> supers = HookingSet.getHookingClassSet(ConfHook.hook_httpservlet_supers);
    public HashSet<String> filters = HookingSet.getHookingClassSet(ConfHook.hook_http_filters);

    public HttpServiceASM() {
        if (ConfHook.hook_http_default_enabled) {
            this.servlets.add("javax/servlet/http/HttpServlet");
            this.servlets.add("weblogic/servlet/jsp/JspBase");
            this.servlets.add("org/apache/catalina/core/ApplicationFilterChain");
            this.filters.add("javax/servlet/Filter");
        }
    }

    public void reserved(ReservedSet classSet) {
        classSet.addClass(this.servlets);
        classSet.addInterface("javax/servlet/Filter");
    }

    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!ConfHook.hook_http_enabled) {
            return cv;
        }
        HookingSet hset = WeavingHookSet.http.get(className);
        if (hset != null) {
            return new HttpServiceCV(cv, className);
        }
        if (this.servlets.contains(className)) {
            return new HttpServiceCV(cv, className);
        }
        if (this.supers.contains(classDesc.superName)) {
            return new HttpServiceCV(cv, className);
        }
        for (int i = 0; i < classDesc.interfaces.length; ++i) {
            if (!this.filters.contains(classDesc.interfaces[i])) continue;
            return new HttpServiceCV(cv, className);
        }
        return cv;
    }
}

