/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import whatap.agent.asm.IASM;
import whatap.agent.asm.util.AsmUtil;
import whatap.agent.trace.TraceMain;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Opcodes;
import whatap.org.objectweb.asm.Type;
import whatap.org.objectweb.asm.commons.LocalVariablesSorter;

class GtidArgsMV
extends LocalVariablesSorter
implements Opcodes {
    private static final String TRACE_MAIN = TraceMain.class.getName().replace('.', '/');
    private static final String START_METHOD = "gtidArgs";
    private static final String START_SIGNATURE = "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V";
    private int strArgIdx;
    private String className;
    private String methodName;

    public GtidArgsMV(int access, String desc, MethodVisitor mv, Type[] paramTypes, boolean isStatic, String classname, String methodname, String methoddesc) {
        super(IASM.API, access, desc, mv);
        this.strArgIdx = AsmUtil.getStringIdx(access, desc);
        this.className = classname;
        this.methodName = methodname;
    }

    public void visitCode() {
        AsmUtil.PUSH(this.mv, this.className);
        AsmUtil.PUSH(this.mv, this.methodName);
        if (this.strArgIdx >= 0) {
            this.mv.visitVarInsn(25, this.strArgIdx);
        } else {
            AsmUtil.PUSHNULL(this.mv);
        }
        this.mv.visitMethodInsn(184, TRACE_MAIN, START_METHOD, START_SIGNATURE, false);
        this.mv.visitCode();
    }
}

