/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import whatap.agent.asm.DynaServiceMV;
import whatap.agent.asm.IASM;
import whatap.agent.asm.util.AsmUtil;
import whatap.agent.control.dyna.DynaBCIService;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Opcodes;
import whatap.util.HashUtil;

class DynaServiceCV
extends ClassVisitor
implements Opcodes {
    public String className;

    public DynaServiceCV(ClassVisitor cv, String className) {
        super(IASM.API, cv);
        this.className = className;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (mv == null || AsmUtil.isInitMethod(name)) {
            return mv;
        }
        if (!DynaBCIService.isTargetMethod(name, desc)) {
            return mv;
        }
        String fullname = AsmUtil.makeClassAndMethod(this.className, name);
        int fullname_hash = HashUtil.hash(this.className);
        return new DynaServiceMV(access, desc, mv, fullname, fullname_hash);
    }
}

