/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import whatap.agent.asm.IASM;
import whatap.agent.asm.jdbc.JdbcAsm;
import whatap.agent.asm.util.AsmUtil;
import whatap.org.objectweb.asm.Label;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Opcodes;
import whatap.org.objectweb.asm.Type;
import whatap.org.objectweb.asm.commons.LocalVariablesSorter;

class DbcOpenMV
extends LocalVariablesSorter
implements Opcodes {
    private static final String TRACE_SQL = JdbcAsm.TRACE_SQL;
    private static final String START_METHOD = "dbcOpenStart";
    private static final String START_SIGNATURE = "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;";
    private static final String END_METHOD = "dbcOpenEnd";
    private static final String END_SIGNATURE = "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;";
    private static final String END_SIGNATURE2 = "(Ljava/lang/Object;Ljava/lang/Throwable;)V";
    private Label startFinally = new Label();
    private String classname;
    private int statIdx;
    private boolean isStatic = false;

    public DbcOpenMV(int access, String desc, MethodVisitor mv, String classname) {
        super(IASM.API, access, desc, mv);
        this.classname = classname;
        this.isStatic = (access & 8) != 0;
    }

    public void visitCode() {
        this.mv.visitLdcInsn(this.classname);
        if (this.isStatic) {
            AsmUtil.PUSHNULL(this.mv);
        } else {
            this.mv.visitVarInsn(25, 0);
        }
        this.mv.visitMethodInsn(184, TRACE_SQL, START_METHOD, START_SIGNATURE, false);
        this.statIdx = this.newLocal(Type.getType(Object.class));
        this.mv.visitVarInsn(58, this.statIdx);
        this.mv.visitLabel(this.startFinally);
        this.mv.visitCode();
    }

    public void visitInsn(int opcode) {
        if (opcode >= 172 && opcode <= 177) {
            this.mv.visitVarInsn(25, this.statIdx);
            this.mv.visitMethodInsn(184, TRACE_SQL, END_METHOD, END_SIGNATURE, false);
            this.mv.visitTypeInsn(192, "java/sql/Connection");
        }
        this.mv.visitInsn(opcode);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        Label endFinally = new Label();
        this.mv.visitTryCatchBlock(this.startFinally, endFinally, endFinally, null);
        this.mv.visitLabel(endFinally);
        this.mv.visitInsn(89);
        int errIdx = this.newLocal(Type.getType(Throwable.class));
        this.mv.visitVarInsn(58, errIdx);
        this.mv.visitVarInsn(25, this.statIdx);
        this.mv.visitVarInsn(25, errIdx);
        this.mv.visitMethodInsn(184, TRACE_SQL, END_METHOD, END_SIGNATURE2, false);
        this.mv.visitInsn(191);
        this.mv.visitMaxs(maxStack + 8, maxLocals + 2);
    }
}

