/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.app;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import whatap.agent.Logger;
import whatap.agent.app.IAppCtx;
import whatap.util.AnsiPrint;
import whatap.util.StringUtil;

public class AppCtxParserLoader {
    private static String jarpath;
    private static String appCtxClass;
    private static long jarFileTime;
    private static IAppCtx ctxParser;

    public static IAppCtx load(String newJarpath, String className) {
        try {
            if (StringUtil.isEmpty(newJarpath)) {
                jarpath = null;
                jarFileTime = -1L;
                ctxParser = null;
                return null;
            }
            File jarFile = new File(newJarpath);
            if (!jarFile.exists()) {
                jarpath = null;
                jarFileTime = -1L;
                ctxParser = null;
                return null;
            }
            if (ctxParser != null && className.equals(appCtxClass) && newJarpath.equals(jarpath) && jarFile.lastModified() == jarFileTime) {
                return ctxParser;
            }
            jarFileTime = jarFile.lastModified();
            jarpath = newJarpath;
            appCtxClass = className;
            URLClassLoader loader = new URLClassLoader(new URL[]{jarFile.toURI().toURL()}, AppCtxParserLoader.class.getClassLoader());
            try {
                ctxParser = (IAppCtx)Class.forName(className, true, loader).newInstance();
                Logger.yellow("IAppCtx load: " + className);
            }
            catch (Exception e) {
                Logger.yellow("IAppCtx load fail: " + className + " " + e.getMessage());
            }
        }
        catch (RuntimeException t) {
            Logger.yellow(AnsiPrint.red("IAppCtx dir=" + newJarpath + " load fail: " + t));
        }
        catch (Throwable t) {
            Logger.yellow(AnsiPrint.red("IAppCtx dir=" + newJarpath + " load fail: " + t));
        }
        return ctxParser;
    }

    static {
        jarFileTime = -1L;
    }
}

