/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.api.trace;

import whatap.agent.Configure;
import whatap.agent.ParamSecurity;
import whatap.agent.SecurityMaster;
import whatap.agent.api.trace.TxTrace;
import whatap.agent.conf.ConfTrace;
import whatap.agent.data.DataProfileAgent;
import whatap.agent.data.DataTextAgent;
import whatap.agent.stat.ErrorArg;
import whatap.agent.stat.StatError;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.TraceContextManager;
import whatap.agent.trace.exception.ExceptionAlert;
import whatap.lang.pack.ProfilePack;
import whatap.lang.service.TxRecord;
import whatap.lang.step.MessageStepX;
import whatap.lang.value.DecimalValue;
import whatap.lang.value.TextValue;
import whatap.notice.WHATAP_ERROR;
import whatap.util.DateUtil;
import whatap.util.HashUtil;
import whatap.util.KeyGen;
import whatap.util.SysJMX;

public class TxChild {
    static Configure conf = Configure.getInstance();

    public static TraceContext startChild(TraceContext pctx, String name) {
        if (pctx == null) {
            return null;
        }
        long ctxid = KeyGen.next();
        int parentOffsetTime = pctx.getElapsedTime();
        String title = "(SubTx)" + pctx.service_name;
        MessageStepX step = new MessageStepX();
        step.start_time = pctx.getElapsedTime();
        step.title = title;
        step.desc = name + "#" + ctxid;
        step.setAttr("ctxid", new DecimalValue(ctxid));
        step.setAttr("offset", new DecimalValue(parentOffsetTime));
        long stepId = KeyGen.next();
        step.setAttr("stepId", new DecimalValue(stepId));
        pctx.profile.add(step);
        TraceContext ctx = new TraceContext(ConfTrace._trace_collecting_mode);
        ctx.parent = pctx;
        ctx.thread = Thread.currentThread();
        ctx.txid = ctxid;
        ctx.mtid = pctx.mtid;
        ctx.mtid_build_checked = true;
        ctx.mdepth = pctx.mdepth;
        ctx.service_name = title;
        ctx.service_hash = HashUtil.hash(ctx.service_name);
        ctx.mcaller_txid = pctx.txid;
        ctx.mcaller_stepId = stepId;
        if (TxChild.conf.trace_cpu_endpoint_enabled) {
            ctx.start_cpu = SysJMX.getCurrentThreadCPU();
        }
        if (TxChild.conf.trace_malloc_endpoint_enabled) {
            ctx.start_malloc = SysJMX.getCurrentThreadAllocBytes();
        }
        ctx.resetStartTime(parentOffsetTime);
        ctx.extraFields().put("ParentTx", Long.toString(pctx.txid));
        ctx.extraFields().put("OffsetTime", Integer.toString(parentOffsetTime));
        return ctx;
    }

    public static TraceContext startSpringAsync(TraceContext pctx, String name, long stepId, long childTxId) {
        if (pctx == null) {
            return null;
        }
        long ctxid = childTxId;
        if (ctxid == 0L) {
            ctxid = KeyGen.next();
        }
        int parentOffsetTime = pctx.getElapsedTime();
        TraceContext ctx = new TraceContext(ConfTrace._trace_collecting_mode);
        ctx.parent = pctx;
        ctx.thread = Thread.currentThread();
        ctx.txid = ctxid;
        ctx.mtid = pctx.mtid;
        ctx.mtid_build_checked = true;
        ctx.mdepth = pctx.mdepth;
        ctx.service_name = name;
        ctx.service_hash = HashUtil.hash(ctx.service_name);
        ctx.mcaller_txid = pctx.txid;
        ctx.mcaller_stepId = stepId;
        if (TxChild.conf.trace_cpu_endpoint_enabled) {
            ctx.start_cpu = SysJMX.getCurrentThreadCPU();
        }
        if (TxChild.conf.trace_malloc_endpoint_enabled) {
            ctx.start_malloc = SysJMX.getCurrentThreadAllocBytes();
        }
        ctx.resetStartTime(parentOffsetTime);
        ctx.extraFields().put("ParentTx", Long.toString(pctx.txid));
        ctx.extraFields().put("OffsetTime", Integer.toString(parentOffsetTime));
        TraceContextManager.start(ctx);
        TxChild.checkTraceAsyncAnnotation(ctx);
        return ctx;
    }

    private static void checkTraceAsyncAnnotation(TraceContext ctx) {
        if (!ConfTrace.trace_spring_async_annotation_activetx_list_enabled) {
            ctx.addActiveTxListEnabled = false;
        }
        if (!ConfTrace.trace_spring_async_annotation_activetx_counter_enabled) {
            ctx.addActiveTxCounterEnabled = false;
        }
    }

    public static void attachChild(TraceContext ctx) {
        TraceContextManager.attach(ctx);
    }

    public static void endChild(TraceContext ctx, Throwable thr) {
        if (ctx != null) {
            TxChild.endChildTx(ctx, thr);
        }
    }

    private static void endChildTx(TraceContext ctx, Throwable thr) {
        ctx.close();
        ctx.handleEndTxErrorStack(thr);
        if (ConfTrace.trace_exception_overwrite_enabled && ctx.exception != null && ctx.error != null && ctx.exception != ctx.error.exception) {
            ctx.error = null;
        }
        TraceContextManager.end(ctx.txid);
        boolean isNew = DataTextAgent.SERVICE.add(ctx.service_hash, ctx.service_name);
        ProfilePack profile = new ProfilePack();
        TxRecord tx = new TxRecord();
        tx.txid = ctx.txid;
        if (ConfTrace.txtext_txname_enabled) {
            tx.txName = ctx.service_name;
        }
        tx.wclientId = ctx.wclientId;
        tx.cipher = ParamSecurity.keyHash;
        tx.userAgent = ctx.userAgent;
        tx.mcaller_pcode = ctx.mcaller_pcode;
        tx.mcaller_okind = ctx.mcaller_okind;
        tx.mcaller_oid = ctx.mcaller_oid;
        tx.custid = ctx.custid;
        tx.mtid = ctx.mtid;
        tx.mdepth = ctx.mdepth;
        tx.mcaller = ctx.mcaller_txid;
        tx.mcallerStepId = ctx.mcaller_stepId;
        if (ConfTrace.trace_origin_url_enabled) {
            tx.originUrl = ctx.origin_url;
        }
        tx.endTime = ctx.endTime = DateUtil.currentTime();
        tx.elapsed = ctx.elapsed = ctx.getElapsedTime();
        if (tx.elapsed < 0) {
            ctx.elapsed = 0;
            tx.elapsed = 0;
        }
        tx.service = ctx.service_hash;
        if (ctx.start_cpu > 0L) {
            tx.cpuTime = (int)(SysJMX.getCurrentThreadCPU() - ctx.start_cpu);
        }
        if (ctx.start_malloc > 0L) {
            tx.malloc = SysJMX.getCurrentThreadAllocBytes() - ctx.start_malloc;
        }
        tx.sqlCount = ctx.sql_count;
        tx.sqlTime = ctx.sql_time;
        tx.sqlFetchCount = ctx.rs_count;
        tx.sqlFetchTime = (int)ctx.rs_time;
        tx.dbcTime = ctx.dbc_time;
        tx.methodCount = ctx.method_count;
        tx.methodTime = ctx.method_time;
        if (ctx.error != null) {
            tx.error = ctx.error.txErrorCode;
            tx.errorLevel = ctx.error.level;
            if (TxTrace.isBizException(ctx.error.className.hashCode())) {
                tx.errorLevel = (byte)10;
            }
            TxTrace.errorMessageToTx(tx, ctx.error);
        } else if (ctx.exception != null && !TxTrace.isIgnoreExceptionTx(ctx.exception, ctx.service_hash, ctx.service_name)) {
            ErrorArg arg = new ErrorArg();
            arg.exception = ctx.exception;
            arg.message = ctx.exception.getMessage();
            arg.status = ctx.status;
            arg.setTraceCtx(ctx);
            tx.error = StatError.getInstance().addError(arg);
            if (TxTrace.isBizException(ctx.exception) || TxTrace.isBizExceptionAndStaus(ctx.exception, ctx.status)) {
                tx.errorLevel = (byte)10;
            } else {
                tx.errorLevel = (byte)20;
                ExceptionAlert.getInstance().service(ctx, arg);
            }
            TxTrace.errorMessageToTx(tx, arg);
        } else if (ctx.unclosedConnMap != null && ctx.unclosedConnMap.size() > 0) {
            ErrorArg arg = new ErrorArg();
            arg.exception = WHATAP_ERROR.connection_not_close;
            arg.message = WHATAP_ERROR.connection_not_close.getMessage();
            arg.status = ctx.status;
            arg.setTraceCtx(ctx);
            StackTraceElement[] stack = ctx.unclosedConnMap.entries().nextElement().getValue();
            tx.error = StatError.getInstance().addJdbcLeak(arg, stack);
            tx.errorLevel = (byte)20;
            TxTrace.errorMessageToTx(tx, arg);
        } else if (ctx.unclosedStmtMap != null && ctx.unclosedStmtMap.size() > 0) {
            ErrorArg arg = new ErrorArg();
            arg.exception = WHATAP_ERROR.stmt_not_close;
            arg.message = WHATAP_ERROR.stmt_not_close.getMessage();
            arg.status = ctx.status;
            arg.setTraceCtx(ctx);
            StackTraceElement[] stack = ctx.unclosedStmtMap.entries().nextElement().getValue();
            tx.error = StatError.getInstance().addJdbcLeak(arg, stack);
            tx.errorLevel = (byte)20;
            TxTrace.errorMessageToTx(tx, arg);
        } else if (ctx.customLeak > 0) {
            ErrorArg arg = new ErrorArg();
            arg.exception = WHATAP_ERROR.custom_leak;
            arg.message = WHATAP_ERROR.custom_leak.getMessage();
            arg.status = ctx.status;
            arg.setTraceCtx(ctx);
            tx.error = StatError.getInstance().addError(arg);
            tx.errorLevel = (byte)20;
            TxTrace.errorMessageToTx(tx, arg);
        }
        tx.domain = ctx.http_host_hash;
        tx.referer = ctx.referer;
        tx.httpcCount = ctx.httpc_count;
        tx.httpcTime = ctx.httpc_time;
        if (ctx.remoteAddrIPv6) {
            ctx.setExtraField("RemoteIp6", new TextValue(ctx.remoteAddr));
        } else {
            tx.ipaddr = ctx.remoteIp;
        }
        tx.fields = ctx.fields;
        if (ConfTrace.trace_thread_id_enabled && ctx.thread != null) {
            ctx.setExtraField("threadId", new DecimalValue(ctx.thread.getId()));
        }
        if (ConfTrace.trace_thread_name_enabled && ctx.thread != null) {
            ctx.setExtraField("threadName", new TextValue(ctx.thread.getName()));
        }
        profile.oid = SecurityMaster.getInstance().OID;
        profile.transaction = tx;
        profile.time = tx.endTime;
        DataProfileAgent.sendChildProfile(ctx, profile, thr == TxTrace.REJECT);
        ctx.reset();
    }
}

