/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.util.TimeZone;
import whatap.Version;
import whatap.agent.conf.ConfLog;
import whatap.agent.util.LogFormat;
import whatap.lang.conf.ConfObserver;
import whatap.lang.value.MapValue;
import whatap.util.AnsiPrint;
import whatap.util.CompareUtil;
import whatap.util.DateTimeHelper;
import whatap.util.FileUtil;
import whatap.util.IClose;
import whatap.util.StringLongLinkedMap;
import whatap.util.StringUtil;
import whatap.util.ThreadUtil;

public class Logger {
    public static String oname;
    private static StringLongLinkedMap lastLog;
    private static String logtimezone;
    static PrintWriter pw;
    static File logfile;
    private static String logname;
    private static String logroot;
    static long ROTATION_UNIT;
    static Thread logThread;
    static long last_open_error;

    public static void println(String id, int interval, Object message) {
        if (!Logger.checkOk(id, interval)) {
            return;
        }
        Logger.write(LogFormat.build(oname, id, Logger.toString(message)), false);
    }

    public static void println(String id, int interval, Throwable t) {
        if (!Logger.checkOk(id, interval)) {
            return;
        }
        Logger.write(LogFormat.build(oname, id, t.toString()), false);
        Logger.write(ThreadUtil.getStackTrace(t), false);
    }

    public static void println(String id, int interval, Throwable t, boolean stack) {
        if (!Logger.checkOk(id, interval)) {
            return;
        }
        Logger.write(LogFormat.build(oname, id, t.toString()), false);
        if (stack) {
            Logger.write(ThreadUtil.getStackTrace(t), false);
        }
    }

    public static void println(String id, int interval, String message, Throwable t) {
        if (!Logger.checkOk(id, interval)) {
            return;
        }
        Logger.write(LogFormat.build(oname, id, message), false);
        Logger.write(ThreadUtil.getStackTrace(t), false);
    }

    public static void println(String id, int interval, String message, Throwable t, boolean stack) {
        if (!Logger.checkOk(id, interval)) {
            return;
        }
        Logger.write(LogFormat.build(oname, id, message + t.getMessage()), false);
        if (stack) {
            Logger.write(ThreadUtil.getStackTrace(t), false);
        }
    }

    private static String toString(Object message) {
        return message == null ? "null" : message.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCallStack(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            t.printStackTrace(pw);
            String string = sw.toString();
            return string;
        }
        finally {
            pw.close();
        }
    }

    public static boolean checkOk(String id, int sec) {
        if (ConfLog.isIgnoreLog(id)) {
            return false;
        }
        if (sec > 0) {
            long last = lastLog.get(id);
            long now = System.currentTimeMillis();
            if (now < last + (long)(sec * 1000)) {
                return false;
            }
            lastLog.put(id, now);
        }
        return true;
    }

    private static void write(String msg, boolean sysout) {
        block4: {
            try {
                if (pw != null) {
                    pw.println(msg);
                    pw.flush();
                }
                if (sysout) {
                    System.out.println(msg);
                }
            }
            catch (Throwable e) {
                pw = (PrintWriter)FileUtil.close(pw);
                if (!sysout) break block4;
                System.out.println(msg);
            }
        }
    }

    public static void write(String msg) {
        try {
            if (pw != null) {
                pw.print(msg);
                pw.flush();
            }
        }
        catch (Throwable e) {
            pw = (PrintWriter)FileUtil.close(pw);
        }
    }

    public static void update(String logroot, String logname) {
        logroot = StringUtil.trimEmpty(logroot);
        logname = StringUtil.trimEmpty(logname);
        if (logroot.equals(Logger.logroot) && logname.equals(Logger.logname)) {
            return;
        }
        Logger.logroot = logroot;
        Logger.logname = logname;
        pw = (PrintWriter)FileUtil.close(pw);
        try {
            Logger.openFile();
        }
        catch (Throwable t) {
            Logger.sysout(t.getMessage());
        }
    }

    public static void start() {
        try {
            Logger.openFile();
            if (pw != null) {
                pw.println("");
                pw.println("WhaTap Java v" + Version.getFullVersion());
                pw.println("Start " + LogFormat.dateHelper.datetime(System.currentTimeMillis()));
                pw.println(logfile.getAbsolutePath());
                pw.println("");
                pw.flush();
            }
        }
        catch (Throwable t) {
            Logger.sysout(t.getMessage());
        }
    }

    public static void setProcName(String nm) {
        oname = StringUtil.truncate(nm, 50);
    }

    private static synchronized void openFile() throws IOException {
        if (pw == null) {
            File root = new File(logroot);
            if (!root.canWrite()) {
                root.mkdirs();
            }
            if (!root.canWrite()) {
                return;
            }
            File file = new File(root, logname + ".log");
            pw = new PrintWriter(new FileWriter(file, true));
            logfile = file;
        }
    }

    protected static void check() {
        if (!ConfLog.log_rotation_enabled) {
            return;
        }
        if (ConfLog.log_keep_days <= 0) {
            return;
        }
        if (StringUtil.isEmpty(logname) || StringUtil.isEmpty(logroot)) {
            return;
        }
        long day = 86400000L;
        long keep_stime = System.currentTimeMillis() / day * day - (long)ConfLog.log_keep_days * day;
        long check_stime = keep_stime - 3L * day;
        File root = new File(logroot);
        for (long time = check_stime; time < keep_stime; time += 86400000L) {
            try {
                File file = new File(root, logname + "-" + LogFormat.dateHelper.yyyymmdd(time) + ".log");
                if (file.exists()) {
                    file.delete();
                    Logger.red("delete log: " + file);
                }
                for (int i = 1; i < 100 && (file = Logger.newFile(root, time, i)).exists(); ++i) {
                    file.delete();
                    Logger.red("delete log: " + file);
                }
                continue;
            }
            catch (Throwable t) {
                Logger.red("delete log: " + t);
            }
        }
    }

    private static File newFile(File root, long time, int i) {
        return new File(root, logname + "-" + LogFormat.dateHelper.yyyymmdd(time) + ".log." + i);
    }

    public static void println(String message) {
        Logger.write(LogFormat.build(oname, message), false);
    }

    public static void println(String message, Throwable t) {
        Logger.write(LogFormat.build(oname, message), false);
        Logger.write(ThreadUtil.getStackTrace(t), false);
    }

    public static void println(String id, String message) {
        message = LogFormat.build(oname, id, message);
        Logger.write(message, false);
    }

    public static void println(String id, String message, Throwable t) {
        message = LogFormat.build(oname, id, message);
        Logger.write(message, false);
        Logger.write(ThreadUtil.getStackTrace(t), false);
    }

    public static void print(String id, String message) {
        message = LogFormat.build(oname, id, message);
        Logger.write(message, false);
    }

    public static void info(String id, String message) {
        message = LogFormat.build(oname, id, message);
        Logger.write(message, false);
    }

    private static void sysout(String message) {
        long now = System.currentTimeMillis();
        if (now - last_open_error >= 60000L) {
            last_open_error = now;
            System.out.println(message);
        }
    }

    public static MapValue getLogFiles() {
        long agoOneMonthTime = LogFormat.dateHelper.getMonth(System.currentTimeMillis(), -1);
        MapValue out = new MapValue();
        String whatap_prefix = logname;
        File dir = new File(logroot);
        File curFile = new File(dir, logname + ".log");
        if (curFile.exists()) {
            out.put(curFile.getName(), curFile.length());
        }
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            String date;
            int x;
            String name;
            if (files[i].isDirectory() || !(name = files[i].getName()).startsWith(whatap_prefix + "-") || (x = name.indexOf(46)) < 0 || (date = name.substring(whatap_prefix.length() + 1, x)).length() != 8 || LogFormat.dateHelper.yyyymmdd(date) < agoOneMonthTime) continue;
            try {
                out.put(files[i].getName(), files[i].length());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (out.size() >= 100) break;
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    public static LogData read(String file, long endpos, long length) {
        LogData logData;
        if (file == null || length == 0L) {
            return null;
        }
        String whatap_prefix = logname;
        if (!file.startsWith(whatap_prefix)) {
            return null;
        }
        File dir = new File(logroot);
        File log = new File(dir, file);
        if (endpos < 0L) {
            endpos = log.length();
        }
        long start = Math.max(0L, endpos - length);
        if (!log.canRead() || log.length() < start) {
            return null;
        }
        long available = log.length() - start;
        long readable = Math.min(available, length);
        byte[] buff = new byte[(int)readable];
        RandomAccessFile r = null;
        try {
            r = new RandomAccessFile(log, "r");
            r.seek(start);
            r.read(buff);
            long next = r.getFilePointer();
            next = next + length > r.length() ? -1L : (next += length);
            logData = new LogData(start, next, new String(buff));
        }
        catch (Throwable throwable) {
            FileUtil.close(r);
            catch (Throwable throwable2) {
                FileUtil.close(r);
                throw throwable2;
            }
        }
        FileUtil.close(r);
        return logData;
        return null;
    }

    public static void red(String m) {
        Logger.write(LogFormat.build(oname, AnsiPrint.red(m)), false);
    }

    public static void green(String m) {
        Logger.write(LogFormat.build(oname, AnsiPrint.green(m)), false);
    }

    public static void green(String id, String m) {
        m = LogFormat.build(oname, id, AnsiPrint.green(m));
        Logger.write(m, false);
    }

    public static void yellow(String m) {
        Logger.write(LogFormat.build(oname, AnsiPrint.yellow(m)), false);
    }

    public static void yellow(String id, String m) {
        m = LogFormat.build(oname, id, AnsiPrint.yellow(m));
        Logger.write(m, false);
    }

    protected static void updateTimeZone() {
        try {
            if (!CompareUtil.equals(logtimezone, ConfLog.log_timezone)) {
                logtimezone = ConfLog.log_timezone;
                if (StringUtil.isEmpty(logtimezone) || "GMT".equalsIgnoreCase(logname)) {
                    LogFormat.dateHelper = DateTimeHelper.getDateTimeHelper();
                } else {
                    TimeZone timezone = TimeZone.getTimeZone(logtimezone);
                    LogFormat.dateHelper = DateTimeHelper.getDateTimeHelper(timezone);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        lastLog = new StringLongLinkedMap().setMax(1000);
        logtimezone = "";
        ConfObserver.add("Logger-" + System.currentTimeMillis() % 1000L, new Runnable(){

            public void run() {
                Logger.update(ConfLog.log_root, ConfLog.log_name);
                Logger.updateTimeZone();
            }
        });
        Logger.update(ConfLog.log_root, ConfLog.log_name);
        Logger.updateTimeZone();
        pw = null;
        logfile = null;
        logname = ConfLog.log_name;
        logroot = ConfLog.log_root;
        ROTATION_UNIT = 86400000L;
        logThread = new Thread(){
            long last = System.currentTimeMillis();
            long lastDataUnit = System.currentTimeMillis() / ROTATION_UNIT * ROTATION_UNIT;

            public void run() {
                while (logThread == Thread.currentThread()) {
                    try {
                        if (ConfLog.log_rotation_enabled) {
                            this.process();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }

            public synchronized void process() {
                long now = System.currentTimeMillis();
                if (now > this.last + 3600000L) {
                    this.last = now;
                    Logger.check();
                }
                long nowDateUnit = System.currentTimeMillis() / ROTATION_UNIT * ROTATION_UNIT;
                if (logfile != null && logfile.exists() && this.lastDataUnit != nowDateUnit) {
                    pw = (PrintWriter)FileUtil.close(pw);
                    if (logfile.length() > 100L) {
                        try {
                            File toFile = new File(logfile.getParent(), logname + "-" + LogFormat.dateHelper.yyyymmdd(System.currentTimeMillis() - ROTATION_UNIT) + ".log");
                            int n = 1;
                            while (toFile.exists()) {
                                toFile = new File(logfile.getParent(), logname + "-" + LogFormat.dateHelper.yyyymmdd(System.currentTimeMillis() - ROTATION_UNIT) + ".log." + n);
                                ++n;
                            }
                            logfile.renameTo(toFile);
                        }
                        catch (Throwable toFile) {
                            // empty catch block
                        }
                    }
                }
                this.lastDataUnit = nowDateUnit;
                try {
                    Logger.openFile();
                }
                catch (Throwable t) {
                    Logger.sysout(t.getMessage());
                }
            }
        };
        logThread.setName("WhaTap-Log");
        logThread.setDaemon(true);
        logThread.start();
        last_open_error = 0L;
    }

    public static class LogData {
        public long before;
        public long next;
        public String text;

        public LogData(long pre, long next, String text) {
            this.before = pre;
            this.next = next;
            this.text = text;
        }
    }

    public static class FileLog
    implements IClose {
        private PrintWriter out;

        public FileLog(String filename) {
            try {
                this.out = new PrintWriter(new FileWriter(filename));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void println(String message) {
            if (this.out == null) {
                return;
            }
            this.out.println(LogFormat.dateHelper.datetime(System.currentTimeMillis()) + " " + message);
            this.out.flush();
        }

        public void close() {
            FileUtil.close(this.out);
        }
    }
}

