/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import whatap.agent.Configure;
import whatap.io.DataOutputX;
import whatap.util.Base64;

public class Cypher {
    private Cipher enc;
    private Cipher dec;
    private byte[] xor_key;
    private final int BLOCK;
    private Configure conf = Configure.getInstance();
    public static Cypher dummy = new Cypher(){

        public byte[] hide(byte[] data) {
            return data;
        }

        public byte[] decrypt(byte[] data, int offet, int len) {
            return data;
        }

        public byte[] encrypt(byte[] data) {
            return data;
        }
    };

    private Cypher() {
        this.BLOCK = this.conf.cypher_level / 8;
    }

    public Cypher(byte[] cypher_key, int xor_key) {
        this();
        try {
            if (this.BLOCK == 0) {
                return;
            }
            cypher_key = this.padding(cypher_key);
            SecretKeySpec secretKey = new SecretKeySpec(cypher_key, "AES");
            this.enc = Cipher.getInstance("AES/ECB/NoPadding");
            this.enc.init(1, secretKey);
            this.dec = Cipher.getInstance("AES/ECB/NoPadding");
            this.dec.init(2, secretKey);
            this.xor_key = DataOutputX.toBytes(xor_key);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte[] decrypt(byte[] data, int offet, int len) {
        try {
            if (this.BLOCK == 0) {
                return data;
            }
            return this.dec.doFinal(data, offet, len);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public byte[] encrypt(byte[] data) {
        if (this.BLOCK == 0) {
            return data;
        }
        int len = data.length;
        int remainder = len % this.BLOCK;
        byte[] outb = null;
        if (remainder == 0) {
            outb = data;
        } else {
            outb = new byte[(len / this.BLOCK + 1) * this.BLOCK];
            DataOutputX.set(outb, 0, data);
        }
        try {
            return this.enc.doFinal(outb);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public byte[] encryptBlock(byte[] data) {
        try {
            if (this.BLOCK == 0) {
                return data;
            }
            return this.enc.doFinal(data);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private byte[] padding(byte[] src) {
        if (src.length == this.BLOCK) {
            return src;
        }
        byte[] dest = new byte[this.BLOCK];
        if (src.length > this.BLOCK) {
            System.arraycopy(src, 0, dest, 0, this.BLOCK);
        } else {
            System.arraycopy(src, 0, dest, 0, src.length);
        }
        return dest;
    }

    public byte[] hide(byte[] b) {
        if (this.BLOCK == 0) {
            return b;
        }
        int i = 0;
        int j = 0;
        while (i < b.length) {
            int n = i++;
            b[n] = (byte)(b[n] ^ this.xor_key[j]);
            j = (j + 1) % this.xor_key.length;
        }
        return b;
    }

    public static void main(String[] args) throws Exception {
        String x = "eVbgQpyPuBXBKB/mn9wcgLcCbXB5zCcFDss9Arx/ijS3Am1wecwnBQ7LPQK8f4o03nU43P1p6Omvec0s82HEQ/e73qaIPhU5+baZO4XZBns=";
        byte[] nn = Base64.decode(x);
        Cypher cp = new Cypher("abc".getBytes(), 100);
        nn = cp.decrypt(nn, 0, nn.length);
        System.out.println(new String(nn));
    }
}

