/*
 * Decompiled with CFR 0.152.
 */
package whatap.v1;

import whatap.agent.conf.ConfMTrace;
import whatap.agent.conf.ConfTrace;
import whatap.agent.stat.ErrorArg;
import whatap.agent.trace.TraceContext;
import whatap.util.HashUtil;
import whatap.util.IPUtil;
import whatap.util.KeyGen;
import whatap.v1.HGET;
import whatap.v1.HPUT;

public class TraceCtx {
    public TraceContext ctx;
    public long stepId;

    public void name(String url) {
        if (url != null) {
            this.ctx.service_name = url;
            this.ctx.service_hash = HashUtil.hash(url);
        }
    }

    public void error(Throwable t) {
        ErrorArg arg = new ErrorArg();
        arg.exception = t;
        arg.message = t.getMessage();
        arg.setTraceCtx(this.ctx);
    }

    public void ipaddr(String addr) {
        this.ctx.remoteIp = IPUtil.toInt(addr);
        this.ctx.remoteAddr = addr;
        if (ConfTrace.trace_remote_ip6_enabled && addr != null && addr.indexOf(":") >= 0) {
            this.ctx.remoteAddrIPv6 = true;
        }
    }

    public long setMtid(String mtid) {
        if (mtid != null && mtid.length() > 0) {
            this.ctx.customTrace(mtid);
            return this.ctx.mtid;
        }
        return 0L;
    }

    public long startMtidByRate(int rate) {
        if (!this.ctx.mtid_build_checked) {
            long next = KeyGen.next();
            if (Math.abs(next / 100L % 100L) < (long)rate) {
                this.ctx.mtid = next;
            }
            this.ctx.mtid_build_checked = true;
            return this.ctx.mtid;
        }
        return 0L;
    }

    public void mtrace(HGET m) {
        if (!ConfMTrace.mtrace_enabled) {
            return;
        }
        String value = m.get(ConfMTrace._trace_mtrace_poid_key);
        if (value != null) {
            this.ctx.setCallerPOID(value);
        }
        if ((value = m.get(ConfMTrace._trace_mtrace_spec_key1)) != null) {
            this.ctx.setTransferSPEC_URL1(value);
        }
        if ((value = m.get(ConfMTrace._trace_mtrace_caller_key)) != null) {
            this.ctx.setTransferMTID_CALLERTX(value);
        }
    }

    public void mtrace(HPUT m) {
        if (!ConfMTrace.mtrace_enabled) {
            return;
        }
        m.put(ConfMTrace._trace_mtrace_poid_key, TraceContext.transferPOID());
        if (this.ctx != null) {
            if (ConfMTrace.stat_mtrace_enabled) {
                m.put(ConfMTrace._trace_mtrace_spec_key1, this.ctx.transferSPEC_URL1());
            }
            if (this.ctx.mtid != 0L) {
                this.stepId = TraceContext.getNextCallerStepId();
                m.put(ConfMTrace._trace_mtrace_caller_key, this.ctx.transferMTID_CALLERTX(this.stepId));
            }
        }
    }
}

