/*
 * Decompiled with CFR 0.152.
 */
package whatap.v1;

import java.util.HashMap;
import java.util.Map;
import whatap.agent.api.trace.HttpCallSpec;
import whatap.agent.api.trace.TxHttpC;
import whatap.agent.conf.ConfMTrace;
import whatap.agent.trace.HttpcContext;
import whatap.agent.trace.TraceContext;
import whatap.v1.HttpCallCtx;
import whatap.v1.TraceCtx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpCall {
    public static Map<String, String> mtrace(TraceCtx ctx) {
        HashMap<String, String> header = new HashMap<String, String>();
        if (ConfMTrace.mtrace_enabled) {
            header.put(ConfMTrace._trace_mtrace_poid_key, TraceContext.transferPOID());
            if (ctx != null) {
                if (ConfMTrace.stat_mtrace_enabled) {
                    header.put(ConfMTrace._trace_mtrace_spec_key1, ctx.ctx.transferSPEC_URL1());
                }
                if (ctx.ctx.mtid != 0L) {
                    ctx.stepId = TraceContext.getNextCallerStepId();
                    header.put(ConfMTrace._trace_mtrace_caller_key, ctx.ctx.transferMTID_CALLERTX(ctx.stepId));
                }
            }
        }
        return header;
    }

    public static void mtrace(TraceCtx ctx, Map<String, String> trInfo) {
        if (ctx == null || !ConfMTrace.mtrace_enabled) {
            return;
        }
        String value = trInfo.get(ConfMTrace._trace_mtrace_poid_key);
        if (value != null) {
            ctx.ctx.setCallerPOID(value);
        }
        if ((value = trInfo.get(ConfMTrace._trace_mtrace_spec_key1)) != null) {
            ctx.ctx.setTransferSPEC_URL1(value);
        }
        if ((value = trInfo.get(ConfMTrace._trace_mtrace_caller_key)) != null) {
            ctx.ctx.setTransferMTID_CALLERTX(value);
        }
    }

    public static HttpCallCtx start(TraceCtx ctx, String driver, String host, int port, String url, String param) {
        if (ctx == null) {
            return null;
        }
        HttpCallSpec spec = new HttpCallSpec();
        spec.stepId = ctx.stepId;
        spec.driver = driver;
        spec.host = host;
        spec.port = port;
        spec.url = url;
        spec.parameter = param;
        HttpcContext orgCtx = TxHttpC.startHttpCall(spec);
        if (orgCtx == null) {
            return null;
        }
        HttpCallCtx hctx = new HttpCallCtx();
        hctx.httpc = orgCtx;
        return hctx;
    }

    public static HttpCallCtx start(String host, int port, String url) {
        HttpcContext orgCtx = TxHttpC.startHttpCall(host, port, url);
        if (orgCtx == null) {
            return null;
        }
        HttpCallCtx hctx = new HttpCallCtx();
        hctx.httpc = orgCtx;
        return hctx;
    }

    public static void end(HttpCallCtx hctx, int status, String status_reason, Throwable thr) {
        if (hctx != null) {
            TxHttpC.endHttpCall(hctx.httpc, status, status_reason, thr);
        }
    }

    public static void trace(TraceCtx ctx, String host, int port, String url, int elapsed, int status, String reason, Throwable thr) {
        if (ctx != null) {
            TxHttpC.trace(ctx.ctx, host, port, url, elapsed, status, reason, thr);
        }
    }

    public static void trace(String host, int port, String url, int elapsed, int status, String reason, Throwable thr) {
        TxHttpC.trace(host, port, url, elapsed, status, reason, thr);
    }
}

