/*
 * Decompiled with CFR 0.152.
 */
package whatap.v1;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import whatap.agent.Configure;
import whatap.agent.api.trace.TxTrace;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.TraceContextManager;
import whatap.v1.BranchCtx;
import whatap.v1.Trace;
import whatap.v1.TraceCtx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Branch {
    public static BranchCtx start(TraceCtx pctx) {
        if (pctx == null) {
            return null;
        }
        TraceContext ctx = TxTrace.startBranch(pctx.ctx);
        if (ctx == null) {
            return null;
        }
        BranchCtx bCtx = new BranchCtx();
        bCtx.ctx = ctx;
        bCtx.pctx = pctx.ctx;
        return bCtx;
    }

    public static void end(BranchCtx bctx) {
        if (bctx != null) {
            TxTrace.endBranch(bctx.pctx, bctx.ctx);
            TraceContextManager.detach();
        }
    }

    public static Runnable run(final TraceCtx pctx, final Runnable f) {
        if (pctx == null) {
            return f;
        }
        return new Runnable(){

            public void run() {
                TraceContext ctx = TxTrace.startBranch(pctx.ctx, "Runnable");
                try {
                    f.run();
                }
                finally {
                    TxTrace.endBranch(pctx.ctx, ctx);
                    if (ctx != null) {
                        TraceContextManager.detach();
                    }
                }
            }
        };
    }

    public static Runnable run(Runnable f) {
        return Branch.run(Trace.context(), f);
    }

    public static <T> Supplier<T> supply(final TraceCtx pctx, final Supplier<T> f) {
        if (pctx == null) {
            return f;
        }
        return new Supplier<T>(){

            @Override
            public T get() {
                TraceContext ctx = TxTrace.startBranch(pctx.ctx, "Supplier");
                try {
                    Object t = f.get();
                    return t;
                }
                finally {
                    TxTrace.endBranch(pctx.ctx, ctx);
                    if (ctx != null) {
                        TraceContextManager.detach();
                    }
                }
            }
        };
    }

    public static <T> Supplier<T> supply(Supplier<T> f) {
        return Branch.supply(Trace.context(), f);
    }

    public static <T> Consumer<T> action(final TraceCtx pctx, final Consumer<T> f) {
        if (pctx == null) {
            return f;
        }
        return new Consumer<T>(){

            @Override
            public void accept(T t) {
                TraceContext ctx = TxTrace.startBranch(pctx.ctx, "Consumer");
                try {
                    f.accept(t);
                }
                finally {
                    TxTrace.endBranch(pctx.ctx, ctx);
                    if (ctx != null) {
                        TraceContextManager.detach();
                    }
                }
            }
        };
    }

    public static <T> Consumer<T> action(Consumer<T> f) {
        return Branch.action(Trace.context(), f);
    }

    public static <T> Callable<T> call(final TraceCtx pctx, final Callable<T> f) {
        if (pctx == null) {
            return f;
        }
        return new Callable<T>(){

            @Override
            public T call() throws Exception {
                TraceContext ctx = TxTrace.startBranch(pctx.ctx, "Callable");
                try {
                    Object v = f.call();
                    return v;
                }
                finally {
                    TxTrace.endBranch(pctx.ctx, ctx);
                    if (ctx != null) {
                        TraceContextManager.detach();
                    }
                }
            }
        };
    }

    public static <T> Callable<T> call(Callable<T> f) {
        return Branch.call(Trace.context(), f);
    }

    public static <T> Future<T> future(Future<T> f) {
        return Branch.future(Trace.context(), f);
    }

    public static <T> Future<T> future(final TraceCtx pctx, final Future<T> f) {
        if (pctx == null) {
            return f;
        }
        Configure conf = Configure.getInstance();
        return new Future<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return f.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return f.isCancelled();
            }

            @Override
            public boolean isDone() {
                return f.isDone();
            }

            @Override
            public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                TraceContext ctx = TxTrace.startBranch(pctx.ctx);
                try {
                    Object v = f.get(timeout, unit);
                    return v;
                }
                catch (InterruptedException e) {
                    if (ctx != null) {
                        ctx.handleMethodErrorStack(e);
                    }
                    throw e;
                }
                catch (ExecutionException e) {
                    if (ctx != null) {
                        ctx.handleMethodErrorStack(e);
                    }
                    throw e;
                }
                catch (TimeoutException e) {
                    if (ctx != null) {
                        ctx.handleMethodErrorStack(e);
                    }
                    throw e;
                }
                finally {
                    TxTrace.endBranch(pctx.ctx, ctx);
                    if (ctx != null) {
                        TraceContextManager.detach();
                    }
                }
            }

            @Override
            public T get() throws InterruptedException, ExecutionException {
                TraceContext ctx = TxTrace.startBranch(pctx.ctx);
                try {
                    Object v = f.get();
                    return v;
                }
                catch (InterruptedException e) {
                    if (ctx != null) {
                        ctx.handleMethodErrorStack(e);
                    }
                    throw e;
                }
                catch (ExecutionException e) {
                    if (ctx != null) {
                        ctx.handleMethodErrorStack(e);
                    }
                    throw e;
                }
                finally {
                    TxTrace.endBranch(pctx.ctx, ctx);
                    if (ctx != null) {
                        TraceContextManager.detach();
                    }
                }
            }
        };
    }

    public static <T, R> Function<? super T, R> func(final TraceCtx pctx, final Function<? super T, R> org) {
        if (pctx == null) {
            return org;
        }
        return new Function<T, R>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public R apply(T t) {
                TraceContext ctx = TxTrace.startBranch(pctx.ctx, "Function");
                try {
                    Object r = org.apply(t);
                    return r;
                }
                finally {
                    TxTrace.endBranch(pctx.ctx, ctx);
                    if (ctx != null) {
                        TraceContextManager.detach();
                    }
                }
            }
        };
    }

    public static <T, R> Function<? super T, R> func(Function<? super T, R> org) {
        return Branch.func(Trace.context(), org);
    }
}

