/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import whatap.util.CompareUtil;
import whatap.util.FloatEnumer;
import whatap.util.StringEnumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringFloatLinkedMap {
    private static final int DEFAULT_CAPACITY = 101;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private StringFloatLinkedEntry[] table;
    private StringFloatLinkedEntry header;
    private int count;
    private int threshold;
    private float loadFactor;
    private float NONE = 0.0f;
    private int max;

    public StringFloatLinkedMap(int initCapacity, float loadFactor) {
        if (initCapacity < 0) {
            throw new RuntimeException("Capacity Error: " + initCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new RuntimeException("Load Count Error: " + loadFactor);
        }
        if (initCapacity == 0) {
            initCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new StringFloatLinkedEntry[initCapacity];
        this.header.link_next = this.header.link_prev = (this.header = new StringFloatLinkedEntry(null, 0.0f, null));
        this.threshold = (int)((float)initCapacity * loadFactor);
    }

    public StringFloatLinkedMap() {
        this(101, 0.75f);
    }

    public StringFloatLinkedMap setNullValue(float none) {
        this.NONE = none;
        return this;
    }

    public int size() {
        return this.count;
    }

    public String[] keyArray() {
        String[] _keys = new String[this.size()];
        StringEnumer en = this.keys();
        for (int i = 0; i < _keys.length; ++i) {
            _keys[i] = en.nextString();
        }
        return _keys;
    }

    public synchronized StringEnumer keys() {
        return new Enumer(1);
    }

    public synchronized FloatEnumer values() {
        return new Enumer(2);
    }

    public synchronized Enumeration<StringFloatLinkedEntry> entries() {
        return new Enumer(3);
    }

    public synchronized boolean containsValue(long value) {
        StringFloatLinkedEntry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            StringFloatLinkedEntry e = tab[i];
            while (e != null) {
                if (e.value == (float)value) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(String key) {
        StringFloatLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        StringFloatLinkedEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public synchronized float get(String key) {
        if (key == null) {
            return this.NONE;
        }
        StringFloatLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        StringFloatLinkedEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return e.value;
            }
            e = e.next;
        }
        return this.NONE;
    }

    public synchronized float getFirsValue() {
        if (this.isEmpty()) {
            return this.NONE;
        }
        return this.header.link_next.value;
    }

    public synchronized float getLastValue() {
        if (this.isEmpty()) {
            return this.NONE;
        }
        return this.header.link_prev.value;
    }

    private int hash(String key) {
        return key.hashCode() & Integer.MAX_VALUE;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        StringFloatLinkedEntry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        StringFloatLinkedEntry[] newMap = new StringFloatLinkedEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            StringFloatLinkedEntry old = oldMap[i];
            while (old != null) {
                StringFloatLinkedEntry e = old;
                old = old.next;
                String key = e.key;
                int index = this.hash(key) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public StringFloatLinkedMap setMax(int max) {
        this.max = max;
        return this;
    }

    public float put(String key, float value) {
        return this._put(key, value, 4);
    }

    public float putLast(String key, float value) {
        return this._put(key, value, 2);
    }

    public float putFirst(String key, float value) {
        return this._put(key, value, 1);
    }

    private synchronized float _put(String key, float value, int m) {
        if (key == null) {
            return this.NONE;
        }
        StringFloatLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        StringFloatLinkedEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                float old = e.value;
                e.value = value;
                switch (m) {
                    case 1: {
                        if (this.header.link_next == e) break;
                        this.unchain(e);
                        this.chain(this.header, this.header.link_next, e);
                        break;
                    }
                    case 2: {
                        if (this.header.link_prev == e) break;
                        this.unchain(e);
                        this.chain(this.header.link_prev, this.header, e);
                    }
                }
                return old;
            }
            e = e.next;
        }
        if (this.max > 0) {
            switch (m) {
                case 1: 
                case 3: {
                    String k;
                    while (this.count >= this.max) {
                        k = this.header.link_prev.key;
                        float v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
                case 2: 
                case 4: {
                    String k;
                    while (this.count >= this.max) {
                        k = this.header.link_next.key;
                        float v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
            }
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = this.hash(key) % tab.length;
        }
        tab[index] = e = new StringFloatLinkedEntry(key, value, tab[index]);
        switch (m) {
            case 1: 
            case 3: {
                this.chain(this.header, this.header.link_next, e);
                break;
            }
            case 2: 
            case 4: {
                this.chain(this.header.link_prev, this.header, e);
            }
        }
        ++this.count;
        return this.NONE;
    }

    public float add(String key, float value) {
        return this._add(key, value, 4);
    }

    public float addLast(String key, float value) {
        return this._add(key, value, 2);
    }

    public float addFirst(String key, float value) {
        return this._add(key, value, 1);
    }

    private synchronized float _add(String key, float value, int m) {
        if (key == null) {
            return this.NONE;
        }
        StringFloatLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        StringFloatLinkedEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                float old = e.value;
                e.value += value;
                switch (m) {
                    case 1: {
                        if (this.header.link_next == e) break;
                        this.unchain(e);
                        this.chain(this.header, this.header.link_next, e);
                        break;
                    }
                    case 2: {
                        if (this.header.link_prev == e) break;
                        this.unchain(e);
                        this.chain(this.header.link_prev, this.header, e);
                    }
                }
                return old;
            }
            e = e.next;
        }
        if (this.max > 0) {
            switch (m) {
                case 1: 
                case 3: {
                    String k;
                    while (this.count >= this.max) {
                        k = this.header.link_prev.key;
                        float v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
                case 2: 
                case 4: {
                    String k;
                    while (this.count >= this.max) {
                        k = this.header.link_next.key;
                        float v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
            }
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = this.hash(key) % tab.length;
        }
        tab[index] = e = new StringFloatLinkedEntry(key, value, tab[index]);
        switch (m) {
            case 1: 
            case 3: {
                this.chain(this.header, this.header.link_next, e);
                break;
            }
            case 2: 
            case 4: {
                this.chain(this.header.link_prev, this.header, e);
            }
        }
        ++this.count;
        return this.NONE;
    }

    protected void overflowed(String key, float value) {
    }

    public synchronized float remove(String key) {
        if (key == null) {
            return this.NONE;
        }
        StringFloatLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        StringFloatLinkedEntry e = tab[index];
        StringFloatLinkedEntry prev = null;
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                float oldValue = e.value;
                e.value = this.NONE;
                this.unchain(e);
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return this.NONE;
    }

    public synchronized float removeFirst() {
        if (this.isEmpty()) {
            return this.NONE;
        }
        return this.remove(this.header.link_next.key);
    }

    public synchronized float removeLast() {
        if (this.isEmpty()) {
            return this.NONE;
        }
        return this.remove(this.header.link_prev.key);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isFull() {
        return this.max > 0 && this.max <= this.count;
    }

    public synchronized void clear() {
        StringFloatLinkedEntry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.header.link_next = this.header.link_prev = this.header;
        this.count = 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<StringFloatLinkedEntry> it = this.entries();
        buf.append("{");
        int i = 0;
        while (it.hasMoreElements()) {
            StringFloatLinkedEntry e = it.nextElement();
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(e.getKey() + "=" + e.getValue());
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public String toFormatString() {
        DecimalFormat fm = new DecimalFormat("#,##0");
        StringBuffer buf = new StringBuffer();
        Enumeration<StringFloatLinkedEntry> it = this.entries();
        buf.append("{\n");
        while (it.hasMoreElements()) {
            StringFloatLinkedEntry e = it.nextElement();
            buf.append("\t").append(e.getKey() + "=" + fm.format(e.getValue())).append("\n");
        }
        buf.append("}");
        return buf.toString();
    }

    private void chain(StringFloatLinkedEntry link_prev, StringFloatLinkedEntry link_next, StringFloatLinkedEntry e) {
        e.link_prev = link_prev;
        e.link_next = link_next;
        link_prev.link_next = e;
        link_next.link_prev = e;
    }

    private void unchain(StringFloatLinkedEntry e) {
        e.link_prev.link_next = e.link_next;
        e.link_next.link_prev = e.link_prev;
        e.link_prev = null;
        e.link_next = null;
    }

    public synchronized void sort(Comparator<StringFloatLinkedEntry> c) {
        ArrayList<StringFloatLinkedEntry> list = new ArrayList<StringFloatLinkedEntry>(this.size());
        Enumeration<StringFloatLinkedEntry> en = this.entries();
        while (en.hasMoreElements()) {
            list.add(en.nextElement());
        }
        Collections.sort(list, c);
        this.clear();
        for (int i = 0; i < list.size(); ++i) {
            StringFloatLinkedEntry e = (StringFloatLinkedEntry)list.get(i);
            this.put(e.getKey(), e.getValue());
        }
    }

    private class Enumer
    implements Enumeration,
    StringEnumer,
    FloatEnumer {
        byte type;
        StringFloatLinkedEntry entry;

        Enumer(byte type) {
            this.entry = ((StringFloatLinkedMap)StringFloatLinkedMap.this).header.link_next;
            this.type = type;
        }

        public boolean hasMoreElements() {
            return StringFloatLinkedMap.this.header != this.entry && this.entry != null;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                StringFloatLinkedEntry e = this.entry;
                this.entry = e.link_next;
                switch (this.type) {
                    case 1: {
                        return e.key;
                    }
                    case 2: {
                        return Float.valueOf(e.value);
                    }
                }
                return e;
            }
            throw new NoSuchElementException("no more next");
        }

        public float nextFloat() {
            if (this.hasMoreElements()) {
                StringFloatLinkedEntry e = this.entry;
                this.entry = e.link_next;
                return e.value;
            }
            throw new NoSuchElementException("no more next");
        }

        public String nextString() {
            if (this.hasMoreElements()) {
                StringFloatLinkedEntry e = this.entry;
                this.entry = e.link_next;
                return e.key;
            }
            throw new NoSuchElementException("no more next");
        }
    }

    public static class StringFloatLinkedEntry {
        String key;
        float value;
        StringFloatLinkedEntry next;
        StringFloatLinkedEntry link_next;
        StringFloatLinkedEntry link_prev;

        protected StringFloatLinkedEntry(String key, float value, StringFloatLinkedEntry next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        protected Object clone() {
            return new StringFloatLinkedEntry(this.key, this.value, this.next == null ? null : (StringFloatLinkedEntry)this.next.clone());
        }

        public String getKey() {
            return this.key;
        }

        public float getValue() {
            return this.value;
        }

        public float setValue(float value) {
            float oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof StringFloatLinkedEntry)) {
                return false;
            }
            StringFloatLinkedEntry e = (StringFloatLinkedEntry)o;
            return CompareUtil.equals(e.key, this.key) && CompareUtil.equals(e.value, this.value);
        }

        public int hashCode() {
            return this.key.hashCode() ^ ((int)this.value ^ (int)this.value >>> 32);
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

